/*
 * Decompiled with CFR 0.152.
 */
package blastTools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class ReadBlast {
    ArrayList<Integer> startS = new ArrayList();
    ArrayList<Integer> endS = new ArrayList();
    ArrayList<String> query = new ArrayList();
    ArrayList<String> database = new ArrayList();
    ArrayList<Double> evalue = new ArrayList();
    ArrayList<Integer> length = new ArrayList();
    ArrayList<Integer> startQ = new ArrayList();
    ArrayList<Integer> endQ = new ArrayList();
    ArrayList<Integer> identities = new ArrayList();
    ArrayList<Double> score = new ArrayList();
    ArrayList<Double> percentIdentity = new ArrayList();

    private void getLines(File f) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(f));
            String line = "";
            while ((line = br.readLine()) != null) {
                String[] split = line.split("\\s+");
                this.score.add(Double.parseDouble(split[11]));
                this.startS.add(Integer.parseInt(split[8]));
                this.endS.add(Integer.parseInt(split[9]));
                this.startQ.add(Integer.parseInt(split[6]));
                this.endQ.add(Integer.parseInt(split[7]));
                this.query.add(split[0]);
                this.evalue.add(Double.parseDouble(split[10]));
                this.database.add(split[1]);
                this.length.add(Integer.parseInt(split[3]));
                Double d = Double.parseDouble(split[2]) / 100.0 * (double)this.length.get(this.length.size() - 1).intValue();
                this.identities.add(d.intValue());
                this.percentIdentity.add(Double.parseDouble(split[2]));
            }
            br.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
        }
    }

    public ReadBlast(File f) {
        this.getLines(f);
    }

    public ArrayList<String> getQuery() {
        return this.query;
    }

    public ArrayList<Double> getEvalue() {
        return this.evalue;
    }

    public ArrayList<String> getDatabase() {
        return this.database;
    }

    public ArrayList<Integer> getIdentities() {
        return this.identities;
    }

    public ArrayList<Integer> getLength() {
        return this.length;
    }

    public ArrayList<Integer> getStartQuery() {
        return this.startQ;
    }

    public ArrayList<Integer> getEndQuery() {
        return this.endQ;
    }

    public ArrayList<Integer> getStartDB() {
        return this.startS;
    }

    public ArrayList<Double> getScore() {
        return this.score;
    }

    public ArrayList<Double> getPercentIdentity() {
        return this.percentIdentity;
    }

    public ArrayList<Integer> getEndDB() {
        return this.endS;
    }

    public String get(int i) {
        return String.valueOf(this.query.get(i)) + "\t" + this.database.get(i) + "\t" + this.identities.get(i) + "\t" + this.startQ.get(i) + "\t" + this.endQ.get(i) + "\t" + this.startS.get(i) + "\t" + this.endS.get(i) + "\t" + this.evalue.get(i) + "\t" + this.score.get(i);
    }
}

