/*
 * Decompiled with CFR 0.152.
 */
package buildTreesFromSequenceData;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import rcaller.RCode;
import util.R_functions;

public class AnalyseDeletedSites {
    int covThreshold = 10;
    double polT = 0.9;
    ArrayList<String> names = new ArrayList();
    ArrayList<ArrayList<Double>> data = new ArrayList();

    public static void main(String[] args) {
        File folder = new File(args[0]);
        int covThreshold = Integer.parseInt(args[1]);
        File scriptPath = new File(args[2]);
        double polT = Double.parseDouble(args[3]);
        AnalyseDeletedSites ads = new AnalyseDeletedSites(covThreshold, polT, folder);
        ads.plotHistograms(new File(folder + "/deletedHistograms.jpg"), scriptPath);
        ads.writeDeletedAbovePolT(new File(folder + "/deletedTop" + polT + ".txt"));
    }

    public AnalyseDeletedSites(int covThreshold, double polT, File folder) {
        this.covThreshold = covThreshold;
        this.polT = polT;
        this.readDeletedSites(folder);
    }

    public void readDeletedSites(File folder) {
        File[] files = folder.listFiles();
        int i = 0;
        while (i < files.length) {
            ArrayList<Double> ratios;
            String name = files[i].getName();
            if (name.endsWith("deletedSites.txt") && (ratios = AnalyseDeletedSites.readRatio(files[i], this.covThreshold)).size() > 0) {
                this.data.add(ratios);
                this.names.add(name);
            }
            ++i;
        }
    }

    public void writeDeletedAbovePolT(File out) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(out));
            int i = 0;
            while (i < this.names.size()) {
                int count = 0;
                int j = 0;
                while (j < this.data.get(i).size()) {
                    if (this.data.get(i).get(j) >= this.polT) {
                        ++count;
                    }
                    ++j;
                }
                bw.write(String.valueOf(this.names.get(i)) + "\t" + count + "\n");
                ++i;
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void plotHistograms(File out, File scriptPath) {
        int col = 6;
        int row = this.data.size() / col + 1;
        RCode rc = R_functions.plot_InitJpg(out, row, col);
        int i = 0;
        while (i < this.data.size()) {
            R_functions.makeHistogram(rc, this.data.get(i), 0.0, 1.0, 10, this.names.get(i));
            ++i;
        }
        R_functions.runRCode(rc, scriptPath);
        R_functions.writeRCode(rc, new File(out + ".txt"));
    }

    public static ArrayList<Double> readRatio(File del, int covThreshold) {
        ArrayList<Double> ratios = new ArrayList<Double>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(del));
            while ((line = br.readLine()) != null) {
                String[] split = line.split("\\s+");
                double cov = Double.parseDouble(split[3]);
                if (!(cov >= (double)covThreshold) || split[5].equals("NaN")) continue;
                double ratio = Double.parseDouble(split[5]);
                ratios.add(ratio);
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        return ratios;
    }
}

