/*
 * Decompiled with CFR 0.152.
 */
package buildTreesFromSequenceData;

import buildTreesFromSequenceData.QueryBase;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import pairwiseAlignment.NeedlemanWunsch;
import util.DNAmanipulations;
import util.Fasta;
import util.ObjectIO;
import util.phylogenetics.Alignment;

public class Clashes
implements Serializable {
    private static final long serialVersionUID = 1L;
    HashMap<Integer, HashMap<Integer, ArrayList<Integer>>> posCol = new HashMap();
    HashMap<Integer, Boolean> resolved = new HashMap();
    ArrayList<Integer> unresolved = new ArrayList();
    QueryBase qb = new QueryBase();
    HashMap<ArrayList<Integer>, ArrayList<Integer>> count = new HashMap();
    ArrayList<String> idents;

    public Clashes setIdents(ArrayList<String> idents) {
        this.idents = idents;
        return this;
    }

    public Clashes() {
    }

    public ArrayList<Integer> getQIDColumn(int pos) {
        return this.qb.queryIDs.get(pos);
    }

    public StringBuffer getBaseColumn(int pos) {
        return this.qb.baseColumns.get(pos);
    }

    public void addColumn(ArrayList<Integer> queryIDColumn, StringBuffer bases, int ref) {
        if (!this.count.containsKey(queryIDColumn)) {
            ArrayList<Integer> p = new ArrayList<Integer>();
            p.add(ref);
            this.count.put(queryIDColumn, p);
            this.qb.queryIDs.add(queryIDColumn);
            this.qb.baseColumns.add(bases);
            this.unresolved.add(this.qb.queryIDs.size() - 1);
        } else {
            this.count.get(queryIDColumn).add(ref);
        }
    }

    public QueryBase resolveClashes() {
        this.createPosCol();
        QueryBase resolved = new QueryBase();
        while (this.unresolved.size() > 0) {
            int rand;
            QueryBase result;
            if (this.unresolved.size() % 10000 == 0) {
                System.out.println("Sites still to resolve: " + this.unresolved.size());
            }
            if ((result = this.resolveClash(this.unresolved.get(rand = (int)(Math.random() * (double)this.unresolved.size())))) != null) {
                resolved.addAll(result);
            }
            this.unresolved.remove(rand);
        }
        return resolved;
    }

    private QueryBase resolveClash(int rand) {
        ArrayList<Integer> qIDs = this.qb.queryIDs.get(rand);
        ArrayList<StringBuffer> basesCons = new ArrayList<StringBuffer>();
        ArrayList<ArrayList<Integer>> qIDCons = new ArrayList<ArrayList<Integer>>();
        for (Map.Entry<Integer, HashMap<Integer, ArrayList<Integer>>> e : this.posCol.entrySet()) {
            int i = e.getKey();
            if (!this.posCol.get(i).containsKey(qIDs.get(i))) continue;
            ArrayList<Integer> pos = this.posCol.get(i).get(qIDs.get(i));
            int j = 0;
            while (j < pos.size()) {
                if (!this.resolved.containsKey(pos.get(j))) {
                    ArrayList<Integer> columns = this.qb.queryIDs.get(pos.get(j));
                    StringBuffer bases = this.qb.baseColumns.get(pos.get(j));
                    ArrayList<Integer> p = this.count.get(columns);
                    int k = 0;
                    while (k < p.size()) {
                        if (p.get(k) == i) {
                            basesCons.add(bases);
                            qIDCons.add(columns);
                            p.remove(k);
                            break;
                        }
                        ++k;
                    }
                    if (p.size() == 0) {
                        this.resolved.put(pos.get(j), true);
                    }
                }
                ++j;
            }
        }
        QueryBase consense = null;
        if (basesCons.size() > 0) {
            consense = this.getConsensus(basesCons, qIDCons);
        }
        return consense;
    }

    public void addAll(Clashes newClashes) {
        this.resolved = new HashMap();
        int i = 0;
        while (i < newClashes.size()) {
            ArrayList<Integer> col = newClashes.getQIDColumn(i);
            ArrayList<Integer> p = newClashes.count.get(col);
            StringBuffer baseColumn = newClashes.getBaseColumn(i);
            int j = 0;
            while (j < p.size()) {
                this.addColumn(col, baseColumn, p.get(j));
                ++j;
            }
            ++i;
        }
    }

    public int size() {
        return this.qb.length();
    }

    private ArrayList<String> initbaseCols(ArrayList<StringBuffer> al) {
        ArrayList<String> newAl = new ArrayList<String>();
        if (al.size() > 0) {
            String ref = al.get(0).toString().toUpperCase();
            newAl.add(ref);
            int i = 1;
            while (i < al.size()) {
                String s = al.get(i).toString().toUpperCase();
                if (!s.equals(ref)) {
                    double idRev;
                    String srev = DNAmanipulations.complement(s);
                    double idN = NeedlemanWunsch.getPairwiseIdentity(s, ref);
                    if (idN > (idRev = NeedlemanWunsch.getPairwiseIdentity(srev, ref))) {
                        newAl.add(s);
                    } else {
                        newAl.add(srev);
                    }
                } else {
                    newAl.add(s);
                }
                ++i;
            }
        }
        return newAl;
    }

    private boolean isEqual(ArrayList<StringBuffer> bases) {
        String ref = bases.get(0).toString().toUpperCase();
        int i = 1;
        while (i < bases.size()) {
            String test = bases.get(i).toString().toUpperCase();
            if (!ref.equals(test)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private QueryBase getConsensus(ArrayList<StringBuffer> bases, ArrayList<ArrayList<Integer>> qIDs) {
        ArrayList<Integer> qIDsCons = new ArrayList<Integer>();
        StringBuffer basesCons = new StringBuffer();
        HashMap colHash = new HashMap();
        if (!this.isEqual(bases)) {
            ArrayList<String> baseCols = this.initbaseCols(bases);
            int length = baseCols.get(0).length();
            int j = 0;
            while (j < length) {
                HashMap baseHash = new HashMap();
                int i = 0;
                while (i < qIDs.size()) {
                    String baseCol = baseCols.get(i);
                    ArrayList<Integer> col = qIDs.get(i);
                    char c = baseCol.charAt(j);
                    this.enterItem(baseHash, Character.valueOf(c));
                    if (j < col.size()) {
                        Integer qID = col.get(j);
                        this.enterItem(colHash, qID);
                    }
                    ++i;
                }
                qIDsCons.add((Integer)this.getMax(colHash));
                basesCons.append(this.getMax(baseHash));
                ++j;
            }
            return new QueryBase(qIDsCons, basesCons);
        }
        return new QueryBase(qIDs.get(0), bases.get(0));
    }

    private <T> void enterItem(HashMap<T, Integer> hm, T item) {
        if (hm.containsKey(item)) {
            hm.put(item, hm.get(item) + 1);
        } else {
            hm.put(item, 1);
        }
    }

    private <T> T getMax(HashMap<T, Integer> hm) {
        Iterator<Map.Entry<T, Integer>> it = hm.entrySet().iterator();
        int max = Integer.MIN_VALUE;
        T maxO = null;
        while (it.hasNext()) {
            Map.Entry<T, Integer> e = it.next();
            if (max >= e.getValue()) continue;
            max = e.getValue();
            maxO = e.getKey();
        }
        return maxO;
    }

    private void createPosCol(int start) {
        int i = start;
        while (i < this.qb.queryIDs.size()) {
            if (i % 10000 == 0) {
                System.out.println("Created positional index for " + i + " out of " + this.qb.queryIDs.size());
            }
            ArrayList<Integer> col = this.qb.queryIDs.get(i);
            ArrayList<Integer> refs = this.count.get(col);
            int j = 0;
            while (j < refs.size()) {
                ArrayList<Integer> temp;
                int ref;
                int colPos = ref = refs.get(j).intValue();
                int genomePos = col.get(ref);
                if (this.posCol.containsKey(colPos)) {
                    if (this.posCol.get(colPos).containsKey(genomePos)) {
                        this.posCol.get(colPos).get(genomePos).add(i);
                    } else {
                        temp = new ArrayList();
                        temp.add(i);
                        this.posCol.get(colPos).put(genomePos, temp);
                    }
                } else {
                    temp = new ArrayList<Integer>();
                    temp.add(i);
                    HashMap<Integer, ArrayList<Integer>> hm = new HashMap<Integer, ArrayList<Integer>>();
                    hm.put(genomePos, temp);
                    this.posCol.put(colPos, hm);
                }
                ++j;
            }
            ++i;
        }
    }

    private void createPosCol() {
        this.createPosCol(0);
    }

    public void printAlignment(File out) {
        QueryBase resolved = this.resolveClashes();
        Alignment alg = new Alignment();
        alg.changeIdents(this.idents);
        resolved.sort();
        int i = 0;
        while (i < resolved.length()) {
            alg.addColumn(resolved.baseColumns.get(i).toString());
            ++i;
        }
        Fasta.write(alg.toFasta(), out);
    }

    public Clashes(ArrayList<File> clashFiles) {
        this.mergeFiles(clashFiles);
    }

    public void mergeFiles(ArrayList<File> clashObjectFiles) {
        int size = clashObjectFiles.size();
        int i = 0;
        while (i < size) {
            System.out.println(Runtime.getRuntime().totalMemory());
            System.out.println("Loading and merging " + clashObjectFiles.get(i).getName() + " " + i + " out of " + size + ".");
            System.out.println("Current clash size " + this.size());
            Clashes c = (Clashes)ObjectIO.readObject(clashObjectFiles.get(i));
            System.out.println("Adding reference: " + c.count.get(c.getQIDColumn(0)).get(0));
            if (this.idents != null) {
                if (!this.isEqual(c.idents, this.idents)) {
                    System.out.println("Idents are not equal!");
                    this.printIdents(c.idents);
                }
            } else {
                this.idents = c.idents;
            }
            this.addAll(c);
            ++i;
        }
    }

    private void printColumn(ArrayList<Integer> id) {
        int i = 0;
        while (i < id.size()) {
            System.out.println(id.get(i));
            ++i;
        }
    }

    private void printIdents(ArrayList<String> id) {
        int i = 0;
        while (i < id.size()) {
            System.out.println(id.get(i));
            ++i;
        }
    }

    private boolean isEqual(ArrayList<String> id1, ArrayList<String> id2) {
        if (id1.size() == id2.size()) {
            int i = 0;
            while (i < id1.size()) {
                if (!id1.get(i).equals(id2.get(i))) {
                    return false;
                }
                ++i;
            }
        } else {
            return false;
        }
        return true;
    }
}

