/*
 * Decompiled with CFR 0.152.
 */
package buildTreesFromSequenceData;

import blastTools.PerformBlast;
import blastTools.ReadBlast;
import buildTreesFromSequenceData.ConvertGBKToFasta;
import buildTreesFromSequenceData.RealPhy;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import util.Fasta;

public class DetermineCoreGenome {
    public static void main(String[] args) {
        DetermineCoreGenome.runDetermineCoreGenome(args);
    }

    private static File getGBKFile(String prefix, String[] ext) {
        int i = 0;
        while (i < ext.length) {
            File gbk = new File(String.valueOf(prefix) + "." + ext[i]);
            if (gbk.exists()) {
                return gbk;
            }
            ++i;
        }
        return null;
    }

    public static ArrayList<File> runDetermineCoreGenome(String[] args) {
        File inFolder = new File(args[0]);
        File outFolder = new File(args[1]);
        double perBaseScore = Double.parseDouble(args[2]);
        int flank = Integer.parseInt(args[3]);
        String program = args[4];
        int numberGenomes = Integer.parseInt(args[5]);
        int numberRepeats = Integer.parseInt(args[6]);
        String BLASTPATH = args[7];
        String BLASTBUILDER = args[8];
        String ref = args[9];
        ArrayList<File> cores = new ArrayList<File>();
        int l = 0;
        while (l < numberRepeats) {
            try {
                int k = 0;
                boolean DNA = program.equalsIgnoreCase("blastn");
                File[] list = inFolder.listFiles();
                ArrayList<String> ids = DetermineCoreGenome.chooseGenomes(numberGenomes, list, ref);
                String coreId = DetermineCoreGenome.nameCore(ids, outFolder);
                File core = new File(String.valueOf(coreId) + ".fas");
                File coreFlank = new File(String.valueOf(coreId) + "Flank" + flank + ".fas");
                cores.add(coreFlank);
                HashMap<Object, Object> coreHash = new HashMap();
                HashMap<Object, Object> coreHashFlank = new HashMap();
                int i = 0;
                while (i < ids.size()) {
                    String id = ids.get(i);
                    System.out.println(id);
                    File gbk = DetermineCoreGenome.getGBKFile(inFolder + "/" + id, RealPhy.gbkExt);
                    if (gbk == null) {
                        System.err.println("Cannot find genbank file. Probably an error in the code!");
                        System.exit(-1);
                    }
                    if (++k == 1) {
                        coreHashFlank = ConvertGBKToFasta.writeCDS(gbk, coreFlank, flank, DNA);
                        coreHash = ConvertGBKToFasta.writeCDS(gbk, core, 0, DNA);
                    } else {
                        File gFile = new File(outFolder + "/gFile.fas");
                        gFile.deleteOnExit();
                        ConvertGBKToFasta.writeCDS(gbk, gFile, 0, DNA);
                        File blastout = new File(outFolder + "/blast.out");
                        blastout.deleteOnExit();
                        PerformBlast.blast(BLASTPATH, BLASTBUILDER, program, 1.0E-10, blastout, core, gFile, true, true, DNA, false);
                        File tempNoFlank = new File(outFolder + "/tempNoFlank.fas");
                        File tempFlank = new File(outFolder + "/temp.fas");
                        BufferedWriter bwFlank = new BufferedWriter(new FileWriter(tempFlank));
                        BufferedWriter bwNoFlank = new BufferedWriter(new FileWriter(tempNoFlank));
                        ReadBlast rb = new ReadBlast(blastout);
                        HashMap<String, Fasta> tempHashFlank = new HashMap<String, Fasta>();
                        HashMap<String, Fasta> tempHash = new HashMap<String, Fasta>();
                        String old = "";
                        int j = 0;
                        while (j < rb.getQuery().size()) {
                            if (!old.equals(rb.getQuery().get(j))) {
                                old = rb.getQuery().get(j);
                                String gene = ((Fasta)coreHash.get(old)).getSequence();
                                if (rb.getScore().get(j) / (double)gene.length() > perBaseScore) {
                                    bwFlank.write(">" + ((Fasta)coreHash.get(old)).getIdent() + "\n" + ((Fasta)coreHashFlank.get(old)).getSequence() + "\n");
                                    bwNoFlank.write(">" + ((Fasta)coreHash.get(old)).getIdent() + "\n" + ((Fasta)coreHash.get(old)).getSequence() + "\n");
                                    tempHash.put(old, (Fasta)coreHash.get(old));
                                    tempHashFlank.put(old, (Fasta)coreHashFlank.get(old));
                                }
                            }
                            ++j;
                        }
                        bwFlank.close();
                        bwNoFlank.close();
                        coreHash = tempHash;
                        coreHashFlank = tempHashFlank;
                        tempFlank.renameTo(coreFlank);
                        tempNoFlank.renameTo(core);
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(-1);
            }
            ++l;
        }
        return cores;
    }

    public static String nameCore(ArrayList<String> ids, File outFolder) {
        StringBuffer sb = new StringBuffer(outFolder + "/core+" + ids.get(0));
        return sb.toString();
    }

    public static ArrayList<String> chooseGenomes(int genomes, File[] list, String ref) {
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<File> alist = new ArrayList<File>();
        int refNumber = -1;
        int i = 0;
        while (i < list.length) {
            String name = list[i].getName();
            if (RealPhy.hasExtension(name, RealPhy.gbkExt) || RealPhy.hasExtension(name, RealPhy.fasExt)) {
                alist.add(list[i]);
                if (ref.equals(list[i].getName().split("\\.")[0])) {
                    refNumber = alist.size() - 1;
                }
            }
            ++i;
        }
        int start = 0;
        if (ref.length() > 0) {
            ids.add(ref);
            alist.remove(refNumber);
            start = 1;
        }
        int i2 = start;
        while (alist.size() > 0 && i2 < genomes) {
            int rand = (int)(Math.random() * (double)alist.size());
            File current = (File)alist.get(rand);
            String id = current.getName().split("\\.")[0];
            ids.add(id);
            alist.remove(rand);
            ++i2;
        }
        return ids;
    }
}

