/*
 * Decompiled with CFR 0.152.
 */
package buildTreesFromSequenceData;

import buildTreesFromSequenceData.Genes;
import buildTreesFromSequenceData.GetPolymorphismsClass;
import buildTreesFromSequenceData.Polymorph;
import buildTreesFromSequenceData.RealphyException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import solexa.Arrays;
import solexa.PointSubstitutions;
import util.DNAmanipulations;

public class GetPolymorphismWithGaps
extends GetPolymorphismsClass {
    private static final long serialVersionUID = 1L;

    public GetPolymorphismWithGaps(ArrayList<File> alignmentFiles, ArrayList<String> references, File ReferenceFas, int Flank2, int Quality, double PolymorphismThreshold, double fractionCovThreshold, int PerBaseCoverage, boolean subInfo, boolean NoGenes, double gapThreshold, boolean printInvariant, File outFolder, String reference) throws RealphyException {
        super(alignmentFiles, references, ReferenceFas, Flank2, Quality, PolymorphismThreshold, fractionCovThreshold, PerBaseCoverage, subInfo, NoGenes, printInvariant, outFolder, true, gapThreshold, reference);
    }

    private void checkGapThreshold(double gapThreshold) {
        int strainNumber = this.strains.size();
        int genePolySize = this.genePoly.size();
        int i = 0;
        while (i < genePolySize) {
            Iterator<Map.Entry<Integer, Integer>> it = ((Genes)this.genePoly.get((int)i)).gaps.entrySet().iterator();
            String geneID = ((Genes)this.genePoly.get((int)i)).geneID;
            while (it.hasNext()) {
                Map.Entry<Integer, Integer> e = it.next();
                int gaps = e.getValue();
                double gapProportion = 1.0 * (double)gaps / (double)strainNumber;
                if (!(gapThreshold <= gapProportion)) continue;
                ((Genes)this.genePoly.get((int)i)).polymorphisms.remove(e.getKey());
                for (Map.Entry e2 : this.strains.entrySet()) {
                    ((HashMap)((HashMap)e2.getValue()).get(geneID)).remove(e.getKey());
                }
            }
            ++i;
        }
    }

    @Override
    public void checkCoverageGP(PointSubstitutions pss, String strain) {
        HashMap strainPoly = (HashMap)this.strains.get(strain);
        int genePolySize = this.genePoly.size();
        int i = 0;
        while (i < genePolySize) {
            String id = ((Genes)this.genePoly.get((int)i)).geneID;
            ArrayList<Integer> gaps = this.deleteUnsureRegions(pss, i);
            HashMap geneHM = null;
            if (!strainPoly.containsKey(id)) {
                geneHM = new HashMap();
                strainPoly.put(id, geneHM);
            } else {
                geneHM = (HashMap)strainPoly.get(id);
            }
            int gapsSize = gaps.size();
            int j = 0;
            while (j < gapsSize) {
                int pos = gaps.get(j);
                Genes genes = (Genes)this.genePoly.get(i);
                geneHM.put(pos, new Polymorph('-'));
                if (genes.gaps.containsKey(pos)) {
                    int number = genes.gaps.get(pos);
                    genes.gaps.put(pos, number + 1);
                } else {
                    genes.gaps.put(pos, 1);
                }
                ++j;
            }
            ++i;
        }
        this.checkGapThreshold(this.gapThreshold);
    }

    @Override
    public File writeSequences() {
        File fas = new File(this.outFolder + "/polymorphisms.fas");
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(fas));
            for (Map.Entry e : this.strains.entrySet()) {
                String strainIDIntern = (String)e.getKey();
                String strainIDExtern = this.getStrain(strainIDIntern);
                BufferedWriter bwDet = new BufferedWriter(new FileWriter(new File(this.outFolder + "/" + strainIDExtern + "details.txt")));
                BufferedWriter bwGenePoly = new BufferedWriter(new FileWriter(new File(this.outFolder + "/" + strainIDExtern + "_genePoly.txt")));
                bwGenePoly.write("Strain\tContig\tGene\tRefPos\tSyn\tNonSyn\tratio\tgeneLength\tpoly/geneLength\n");
                bwDet.write("Strain\tContig\tGene\tRefGeneStartPos\tRefGenePos\tRefGenomePos\tOrig\tPoly\n");
                bw.write(">" + strainIDExtern + "\n");
                HashMap strainPoly = (HashMap)e.getValue();
                int posInAlignment = 1;
                int i = 0;
                while (i < this.genePoly.size()) {
                    HashMap polies = (HashMap)strainPoly.get(((Genes)this.genePoly.get((int)i)).geneID);
                    Iterator<Map.Entry<Integer, Character>> it2 = ((Genes)this.genePoly.get((int)i)).polymorphisms.entrySet().iterator();
                    int syn = 0;
                    int nonsyn = 0;
                    String contig = ((Genes)this.genePoly.get((int)i)).contig;
                    while (it2.hasNext()) {
                        if (polies == null) {
                            System.err.println(String.valueOf(((Genes)this.genePoly.get((int)i)).geneID) + " " + strainIDExtern);
                        }
                        Map.Entry<Integer, Character> e2 = it2.next();
                        int pos = e2.getKey();
                        char origBase = e2.getValue().charValue();
                        if (polies.containsKey(pos)) {
                            int GenomePos = ((Genes)this.genePoly.get((int)i)).orient == '+' ? pos + ((Genes)this.genePoly.get((int)i)).pos - 1 : ((Genes)this.genePoly.get((int)i)).length - pos + ((Genes)this.genePoly.get((int)i)).pos;
                            bwDet.write(String.valueOf(strainIDExtern) + "\t" + contig + "\t" + ((Genes)this.genePoly.get((int)i)).geneID + "\t" + ((Genes)this.genePoly.get((int)i)).pos + "\t" + pos + "\t" + GenomePos + "\t" + origBase + "\t" + ((Polymorph)polies.get((Object)Integer.valueOf((int)pos))).base + "\t" + posInAlignment);
                            int frame = (pos - 1) % 3;
                            if (this.genes && ((Genes)this.genePoly.get((int)i)).length > pos - frame + 2) {
                                String origCodon = "" + ((Genes)this.genePoly.get((int)i)).polymorphisms.get(pos - frame) + ((Genes)this.genePoly.get((int)i)).polymorphisms.get(pos - frame + 1) + ((Genes)this.genePoly.get((int)i)).polymorphisms.get(pos - frame + 2);
                                origCodon = String.valueOf(origCodon) + "=" + DNAmanipulations.translate(origCodon, DNAmanipulations.code());
                                char one = polies.containsKey(pos - frame) ? ((Polymorph)polies.get((Object)Integer.valueOf((int)(pos - frame)))).base : ((Genes)this.genePoly.get((int)i)).polymorphisms.get(pos - frame).charValue();
                                char two = polies.containsKey(pos - frame + 1) ? ((Polymorph)polies.get((Object)Integer.valueOf((int)(pos - frame + 1)))).base : ((Genes)this.genePoly.get((int)i)).polymorphisms.get(pos - frame + 1).charValue();
                                char three = polies.containsKey(pos - frame + 2) ? ((Polymorph)polies.get((Object)Integer.valueOf((int)(pos - frame + 2)))).base : ((Genes)this.genePoly.get((int)i)).polymorphisms.get(pos - frame + 2).charValue();
                                String newCodon = "" + one + two + three;
                                newCodon = String.valueOf(newCodon) + "=" + DNAmanipulations.translate(newCodon, DNAmanipulations.code());
                                bwDet.write("\t" + origCodon + "\t" + newCodon + "\n");
                                if (DNAmanipulations.translate(origCodon, DNAmanipulations.code()).equals(DNAmanipulations.translate(newCodon, DNAmanipulations.code()))) {
                                    ++syn;
                                } else {
                                    ++nonsyn;
                                }
                            } else {
                                bwDet.write("\n");
                            }
                            ++posInAlignment;
                            bw.write(((Polymorph)polies.get((Object)Integer.valueOf((int)pos))).base);
                            continue;
                        }
                        ++posInAlignment;
                        bw.write(origBase);
                    }
                    if (this.genes) {
                        bwGenePoly.write(String.valueOf(strainIDExtern) + "\t" + contig + "\t" + ((Genes)this.genePoly.get((int)i)).geneID + "\t" + ((Genes)this.genePoly.get((int)i)).pos + "\t" + syn + "\t" + nonsyn + "\t" + (double)syn / (1.0 * (double)nonsyn) + "\t" + ((Genes)this.genePoly.get((int)i)).length + "\t" + ((double)(syn + nonsyn) + 1.0) / (double)((Genes)this.genePoly.get((int)i)).length + "\n");
                    }
                    ++i;
                }
                bwDet.close();
                bwGenePoly.close();
                bw.write("\n");
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fas;
    }

    @Override
    public HashMap<String, HashMap<Integer, Polymorph>> adjustGP(PointSubstitutions pss, boolean subInfo, String name) {
        HashMap<String, HashMap<Integer, Polymorph>> strainPolymorphism = new HashMap<String, HashMap<Integer, Polymorph>>();
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.outFolder + "/" + name + "deletedSites.txt"));
            int genePolySize = this.genePoly.size();
            int i = 0;
            while (i < genePolySize) {
                String id = ((Genes)this.genePoly.get((int)i)).geneID;
                Arrays geneBases = pss.getBases(id);
                String gene = pss.getGene(id);
                double[] geneCoverage = pss.getCoverage(id);
                if (!strainPolymorphism.containsKey(id)) {
                    strainPolymorphism.put(id, new HashMap());
                }
                int j = 1;
                while (j < geneCoverage.length) {
                    if (geneCoverage[j] >= (double)this.perBaseCoverage) {
                        char base = geneBases.getMaxNucForward(j);
                        double numMajorPoly = geneBases.numMajorPolymorphism(j);
                        double ratioPoly = numMajorPoly / (geneCoverage[j] * 1.0);
                        if (ratioPoly >= this.polymorphismThreshold || this.printInvariant && ratioPoly <= 1.0 - this.polymorphismThreshold) {
                            if (!((Genes)this.genePoly.get((int)i)).polymorphisms.containsKey(j)) {
                                int frame = this.genes ? (j - 1) % 3 : 0;
                                ((Genes)this.genePoly.get((int)i)).polymorphisms.put(j - frame, Character.valueOf(gene.charAt(j - 1 + this.flank - frame)));
                                if (this.genes) {
                                    ((Genes)this.genePoly.get((int)i)).polymorphisms.put(j - frame + 1, Character.valueOf(gene.charAt(j - 1 + this.flank - frame + 1)));
                                    ((Genes)this.genePoly.get((int)i)).polymorphisms.put(j - frame + 2, Character.valueOf(gene.charAt(j - 1 + this.flank - frame + 2)));
                                }
                            }
                            if (numMajorPoly / (geneCoverage[j] * 1.0) >= this.polymorphismThreshold) {
                                if (!subInfo) {
                                    strainPolymorphism.get(id).put(j, new Polymorph(base));
                                } else {
                                    strainPolymorphism.get(id).put(j, new Polymorph(base, this.getMajority(geneBases.getQueryID(j))));
                                }
                            }
                        } else {
                            bw.write(String.valueOf(id) + "\t" + j + "\t" + base + "\t" + geneCoverage[j] + "\t" + numMajorPoly + "\t" + ratioPoly + "\n");
                        }
                    }
                    ++j;
                }
                ++i;
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        return strainPolymorphism;
    }
}

