/*
 * Decompiled with CFR 0.152.
 */
package buildTreesFromSequenceData;

import buildTreesFromSequenceData.Clashes;
import buildTreesFromSequenceData.Genes;
import buildTreesFromSequenceData.GetPolymorphisms;
import buildTreesFromSequenceData.Polymorph;
import buildTreesFromSequenceData.RealPhy;
import buildTreesFromSequenceData.RealphyException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import solexa.Arrays;
import solexa.PointSubstitutions;
import solexa.PointSubstitutionsBAM;
import solexa.PointSubstitutionsSoap;
import util.Fasta;

public abstract class GetPolymorphismsClass
implements GetPolymorphisms,
Serializable {
    public final int BAM = 2;
    public final int soap = 0;
    public final int SAM = 1;
    private static final long serialVersionUID = 1L;
    ArrayList<Genes> genePoly = new ArrayList();
    HashMap<String, HashMap<String, HashMap<Integer, Polymorph>>> strains = new HashMap();
    HashMap<String, HashMap<String, HashMap<Integer, Integer>[]>> baseNames = new HashMap();
    File Reference = null;
    int flank = 0;
    int quality = 20;
    double polymorphismThreshold = 0.95;
    double fractionCovThreshold = 0.93;
    int perBaseCoverage = 10;
    boolean genes = true;
    boolean printInvariant = false;
    File outFolder;
    double gapThreshold = 0.0;
    boolean allowGaps = true;
    String reference;
    private static final HashMap<Character, Boolean> ATGC = new HashMap();

    static {
        ATGC.put(Character.valueOf('A'), true);
        ATGC.put(Character.valueOf('T'), true);
        ATGC.put(Character.valueOf('G'), true);
        ATGC.put(Character.valueOf('C'), true);
        ATGC.put(Character.valueOf('a'), true);
        ATGC.put(Character.valueOf('t'), true);
        ATGC.put(Character.valueOf('g'), true);
        ATGC.put(Character.valueOf('c'), true);
    }

    public static ArrayList<File> getSoapFiles(File inputFolder) {
        ArrayList<File> soapFiles = new ArrayList<File>();
        File[] list = new File(inputFolder + "/soapout/").listFiles();
        int i = 0;
        while (i < list.length) {
            if (list[i].isFile() && list[i].getName().endsWith(".sop")) {
                soapFiles.add(list[i]);
            }
            ++i;
        }
        return soapFiles;
    }

    ArrayList<Integer> deleteUnsureRegions(PointSubstitutions pss, int geneNumber) {
        String id = this.genePoly.get((int)geneNumber).geneID;
        Iterator<Map.Entry<Integer, Character>> it = this.genePoly.get((int)geneNumber).polymorphisms.entrySet().iterator();
        ArrayList<Integer> delete = new ArrayList<Integer>();
        double[] coverage = pss.getCoverage(id);
        Arrays geneBases = pss.getBases(id);
        int k = 0;
        while (it.hasNext()) {
            Map.Entry<Integer, Character> e = it.next();
            int frame = this.genes ? k % 3 : 0;
            int pos = e.getKey();
            char base = e.getValue().charValue();
            double numMajorPoly = geneBases.numMajorPolymorphism(pos);
            double ratioPoly = numMajorPoly / (coverage[pos] * 1.0);
            if (pos < coverage.length && coverage[pos] < (double)this.perBaseCoverage || pos >= coverage.length || !ATGC.containsKey(Character.valueOf(base)) || ratioPoly < this.polymorphismThreshold && ratioPoly > 1.0 - this.polymorphismThreshold) {
                delete.add(pos - frame);
                if (this.genes) {
                    delete.add(pos - frame + 1);
                    delete.add(pos - frame + 2);
                }
            }
            ++k;
        }
        return delete;
    }

    private int initGP(ArrayList<Fasta> fas, boolean addReference) {
        int sum = 0;
        int i = 0;
        while (i < fas.size()) {
            String ident = fas.get(i).getIdent();
            String[] split = ident.split("\\s+");
            String id = split[0];
            String pos = split[1].split("\\.")[0];
            char orient = split[2].charAt(0);
            String contig = split[3];
            sum += fas.get(i).getSequence().length();
            this.genePoly.add(new Genes(id, addReference ? this.referenceTreeMap(fas.get(i).getSequence()) : new TreeMap(), fas.get(i).getSequence().length() - 2 * this.flank, Integer.parseInt(pos), orient, contig));
            ++i;
        }
        return sum;
    }

    private TreeMap<Integer, Character> referenceTreeMap(String seq) {
        TreeMap<Integer, Character> tm = new TreeMap<Integer, Character>();
        int i = 0 + this.flank;
        while (i < seq.length() - this.flank) {
            tm.put(i + 1 - this.flank, Character.valueOf(seq.charAt(i)));
            ++i;
        }
        return tm;
    }

    public GetPolymorphismsClass(ArrayList<File> soapFiles, ArrayList<String> references, File ReferenceFas, int Flank2, int Quality, double PolymorphismThreshold, double FractionCovThreshold, int PerBaseCoverage, boolean subInfo, boolean NoGenes, boolean PrintInvariant, File OutFolder, boolean addReference, double gapThreshold, String ref) throws RealphyException {
        this.Reference = ReferenceFas;
        this.genes = !NoGenes;
        this.flank = Flank2;
        this.quality = Quality;
        this.polymorphismThreshold = PolymorphismThreshold;
        this.fractionCovThreshold = FractionCovThreshold;
        this.perBaseCoverage = PerBaseCoverage;
        this.printInvariant = PrintInvariant;
        this.outFolder = OutFolder;
        this.gapThreshold = gapThreshold;
        this.calculatePolymorphisms(soapFiles, references, subInfo, addReference);
        this.reference = ref;
    }

    public void writeGeneList(File out) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(out));
            bw.write("GeneID\tPos\tlength\tL/#P\tPoly\n");
            int i = 0;
            while (i < this.genePoly.size()) {
                int length = this.genePoly.get((int)i).length;
                double polyprop = (double)this.genePoly.get((int)i).polymorphisms.size() / (1.0 * (double)length);
                bw.write(String.valueOf(this.genePoly.get((int)i).geneID) + "\t" + this.genePoly.get((int)i).pos + "\t" + length + "\t" + polyprop + "\t" + this.genePoly.get((int)i).polymorphisms.size() + "\n");
                ++i;
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getStrain(String name) {
        String[] split = name.split("_");
        if (split[split.length - 1].endsWith("fasta") || split[split.length - 1].endsWith("fastq") || split[split.length - 1].endsWith("fastq.gz")) {
            StringBuffer newName = new StringBuffer();
            newName.append(split[0]);
            int i = 1;
            while (i < split.length - 1) {
                newName.append("_" + split[i]);
                ++i;
            }
            return newName.toString();
        }
        return name;
    }

    private HashMap<String, Boolean> makeHash(ArrayList<String> list) {
        HashMap<String, Boolean> hm = new HashMap<String, Boolean>();
        int i = 0;
        while (i < list.size()) {
            hm.put(list.get(i), true);
            ++i;
        }
        return hm;
    }

    void calculatePolymorphisms(ArrayList<File> alignmentFiles, ArrayList<String> references, boolean subInfo, boolean addReference) throws RealphyException {
        ArrayList<Fasta> ref = Fasta.readFasta(this.Reference);
        int refLength = this.initGP(ref, addReference);
        HashMap<String, Boolean> hmRef = this.makeHash(references);
        try {
            String strainExtern;
            String strainIntern;
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.outFolder + "/polies_and_orthologous_sites.txt"));
            BufferedWriter bwCore = new BufferedWriter(new FileWriter(this.outFolder + "/coreGenomeSize.txt"));
            System.out.println("Strain\t#mapped nucleotides/total possible|Number of polymorphic sites present in all strains analysed to that point\n");
            bw.write("Name|mappedSites|polymorphisms|ratio\n");
            TreeMap<Integer, File> sortedFiles = new TreeMap<Integer, File>();
            int i = 0;
            while (i < alignmentFiles.size()) {
                File alignmentFile = alignmentFiles.get(i);
                int aligner = this.getAligner(alignmentFile);
                strainIntern = RealPhy.getId(alignmentFile.getName());
                strainExtern = this.getStrain(strainIntern);
                boolean basenames = subInfo && hmRef.containsKey(strainExtern);
                PointSubstitutions pss = aligner == 0 ? new PointSubstitutionsSoap(this.Reference, this.flank, alignmentFile, this.quality, basenames) : new PointSubstitutionsBAM(this.Reference, this.flank, alignmentFile, this.quality, basenames);
                HashMap<String, HashMap<Integer, Polymorph>> strainPolies = this.adjustGP(pss, basenames, strainExtern);
                this.strains.put(strainIntern, strainPolies);
                int numberMappedSites = pss.getMappedSites(this.perBaseCoverage);
                int strainPolymorphisms = GetPolymorphismsClass.getStrainPolymorphisms(strainPolies);
                double proportionMutations = (double)strainPolymorphisms / ((double)numberMappedSites * 1.0);
                bw.write(String.valueOf(strainExtern) + "|" + numberMappedSites + "|" + strainPolymorphisms + "|" + proportionMutations + "\n");
                System.out.println(String.valueOf(strainExtern) + "\t" + numberMappedSites + "/" + refLength);
                while (sortedFiles.containsKey(numberMappedSites)) {
                    ++numberMappedSites;
                }
                sortedFiles.put(numberMappedSites, alignmentFiles.get(i));
                ++i;
            }
            bw.close();
            System.out.println("Overall quality check. Strains sorted by divergence from reference strain...");
            for (Map.Entry e : sortedFiles.descendingMap().entrySet()) {
                File alignmentFile = (File)e.getValue();
                strainIntern = RealPhy.getId(alignmentFile.getName());
                strainExtern = this.getStrain(strainIntern);
                int aligner = this.getAligner(alignmentFile);
                boolean basenames = subInfo && hmRef.containsKey(strainExtern);
                PointSubstitutions pss = aligner == 0 ? new PointSubstitutionsSoap(this.Reference, this.flank, alignmentFile, this.quality, basenames) : new PointSubstitutionsBAM(this.Reference, this.flank, alignmentFile, this.quality, basenames);
                this.checkCoverageGP(pss, strainIntern);
                if (basenames) {
                    this.baseNames.put(strainIntern, pss.getBaseNames());
                }
                int numberPolies = this.getNumberPolies();
                int mappedSites = pss.getMappedSites(this.perBaseCoverage);
                System.out.println(String.valueOf(strainExtern) + "\t" + mappedSites + "/" + refLength + "|" + numberPolies);
                bwCore.write(String.valueOf(strainExtern) + "\t" + mappedSites + "/" + refLength + "|" + numberPolies + "\n");
                if (numberPolies != 0) continue;
                throw new RealphyException("For your sequence set there are no positions to which " + (1.0 - this.gapThreshold) * 100.0 + "% of all strains could be mapped. Calculation was aborted with strain " + strainExtern);
            }
            this.writeCoverage(new File(this.outFolder + "/coverage.txt"));
            bwCore.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int getAligner(File alignmentFile) {
        if (alignmentFile.toString().endsWith(".sop")) {
            return 0;
        }
        if (alignmentFile.toString().endsWith(".sam")) {
            return 1;
        }
        return 2;
    }

    private static int getStrainPolymorphisms(HashMap<String, HashMap<Integer, Polymorph>> hm) {
        int count = 0;
        for (Map.Entry<String, HashMap<Integer, Polymorph>> e : hm.entrySet()) {
            count += e.getValue().size();
        }
        return count;
    }

    public int getNumberPolies() {
        int sum = 0;
        int size = this.genePoly.size();
        int i = 0;
        while (i < size) {
            sum += this.genePoly.get((int)i).polymorphisms.size();
            ++i;
        }
        return sum;
    }

    public void writeCoverage(File out) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(out));
            int size = this.genePoly.size();
            int i = 0;
            while (i < size) {
                Genes gene = this.genePoly.get(i);
                int geneLength = gene.length;
                int j = 1;
                while (j < geneLength + 1) {
                    if (gene.polymorphisms.containsKey(j)) {
                        bw.write(String.valueOf(gene.geneID) + "\t1\n");
                    } else {
                        bw.write(String.valueOf(gene.geneID) + "\t0\n");
                    }
                    ++j;
                }
                ++i;
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String[] getStrain(String[] list) {
        String[] newList = new String[list.length];
        int i = 0;
        while (i < newList.length) {
            newList[i] = this.getStrain(list[i]);
            ++i;
        }
        return newList;
    }

    private int getReferencePos(ArrayList<String> sorted) {
        int i = 0;
        while (i < sorted.size()) {
            if (sorted.get(i).equals(this.reference)) {
                return i;
            }
            ++i;
        }
        System.err.println("Could not find reference " + this.reference);
        throw new RuntimeException();
    }

    private int getReferencePos(ArrayList<String> sorted, String[] sortedInt) {
        int refNum = 0;
        int i = 0;
        while (i < sorted.size()) {
            if (sorted.get(i).equals(this.reference)) {
                return refNum;
            }
            if (this.baseNames.containsKey(sortedInt[i])) {
                ++refNum;
            }
            ++i;
        }
        System.err.println("Could not find reference " + this.reference);
        throw new RuntimeException();
    }

    @Override
    public Clashes calculateColumns() {
        String[] strainListIntern = this.strains.keySet().toArray(new String[0]);
        TreeMap<String, Boolean> sortedStrains = this.fillTreeMap(strainListIntern);
        String[] sorted = sortedStrains.keySet().toArray(new String[0]);
        ArrayList<String> sortedEx = this.toExtern(sorted);
        int ref = this.getReferencePos(sortedEx, sorted);
        Clashes columns = new Clashes().setIdents(sortedEx);
        int i = 0;
        while (i < this.genePoly.size()) {
            Genes gene = this.genePoly.get(i);
            for (Map.Entry<Integer, Character> e2 : gene.polymorphisms.entrySet()) {
                int pos = e2.getKey();
                char origBase = e2.getValue().charValue();
                StringBuffer baseColumn = new StringBuffer();
                ArrayList<Integer> queryIDColumn = new ArrayList<Integer>();
                boolean addition = false;
                int j = 0;
                while (j < sorted.length) {
                    String strainEx = this.getStrain(sorted[j]);
                    HashMap<Integer, Polymorph> polies = this.strains.get(sorted[j]).get(gene.geneID);
                    char base = polies.containsKey(pos) ? polies.get((Object)Integer.valueOf((int)pos)).base : origBase;
                    baseColumn.append(base);
                    if (this.baseNames.containsKey(sorted[j])) {
                        int queryID;
                        HashMap<Integer, Integer>[] GeneBaseNames = this.baseNames.get(sorted[j]).get(gene.geneID);
                        if (polies.containsKey(pos)) {
                            if (polies.get((Object)Integer.valueOf((int)pos)).name == null) {
                                System.err.println("something went wrong! polies get pos");
                                System.err.println("pos: " + pos + " strain: " + strainEx);
                                System.exit(-1);
                            }
                            queryID = polies.get((Object)Integer.valueOf((int)pos)).name;
                            addition = true;
                        } else {
                            if (GeneBaseNames[pos] == null) {
                                System.err.println("something went wrong!");
                                System.exit(-1);
                            }
                            queryID = this.getMajority(GeneBaseNames[pos]);
                        }
                        queryIDColumn.add(queryID);
                    }
                    ++j;
                }
                if (!this.printInvariant && !addition) continue;
                columns.addColumn(queryIDColumn, baseColumn, ref);
            }
            ++i;
        }
        return columns;
    }

    int getMajority(HashMap<Integer, Integer> hashMap) {
        Iterator<Map.Entry<Integer, Integer>> it = hashMap.entrySet().iterator();
        int max = 0;
        int maxItem = -1;
        while (it.hasNext()) {
            Map.Entry<Integer, Integer> e = it.next();
            if (e.getValue() <= max) continue;
            max = e.getValue();
            maxItem = e.getKey();
        }
        return maxItem;
    }

    private ArrayList<String> toExtern(String[] internIDs) {
        ArrayList<String> strains = new ArrayList<String>();
        int i = 0;
        while (i < internIDs.length) {
            strains.add(this.getStrain(internIDs[i]));
            ++i;
        }
        return strains;
    }

    private TreeMap<String, Boolean> fillTreeMap(String[] strains) {
        TreeMap<String, Boolean> sorted = new TreeMap<String, Boolean>();
        int i = 0;
        while (i < strains.length) {
            sorted.put(strains[i], true);
            ++i;
        }
        return sorted;
    }
}

