/*
 * Decompiled with CFR 0.152.
 */
package buildTreesFromSequenceData;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class QueryBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    ArrayList<ArrayList<Integer>> queryIDs = new ArrayList();
    ArrayList<StringBuffer> baseColumns = new ArrayList();

    public void addAll(QueryBase qb) {
        this.queryIDs.addAll(qb.queryIDs);
        this.baseColumns.addAll(qb.baseColumns);
    }

    public QueryBase() {
    }

    public QueryBase(ArrayList<ArrayList<Integer>> queryIDCols, ArrayList<StringBuffer> baseCols) {
        this.queryIDs = queryIDCols;
        this.baseColumns = baseCols;
    }

    public void sort() {
        TreeMap<Integer, Integer> tm = new TreeMap<Integer, Integer>();
        int i = 0;
        while (i < this.queryIDs.size()) {
            tm.put(this.queryIDs.get(i).get(0), i);
            ++i;
        }
        ArrayList<ArrayList<Integer>> sortedqIDs = new ArrayList<ArrayList<Integer>>();
        ArrayList<StringBuffer> sortedBaseColumns = new ArrayList<StringBuffer>();
        for (Map.Entry e : tm.entrySet()) {
            int i2 = (Integer)e.getValue();
            sortedqIDs.add(this.queryIDs.get(i2));
            sortedBaseColumns.add(this.baseColumns.get(i2));
        }
        this.queryIDs = sortedqIDs;
        this.baseColumns = sortedBaseColumns;
    }

    public void addGaps() {
        int last = -1;
        int number = this.queryIDs.get(0).size();
        StringBuffer gaps = this.getGaps(number);
        ArrayList<ArrayList<Integer>> gappedqIDs = new ArrayList<ArrayList<Integer>>();
        ArrayList<StringBuffer> gappedBases = new ArrayList<StringBuffer>();
        int i = 0;
        while (i < this.queryIDs.size()) {
            int current = this.queryIDs.get(i).get(0);
            int j = last;
            while (j < current - 1) {
                gappedqIDs.add(this.getQIDs(j, number));
                gappedBases.add(gaps);
                ++j;
            }
            gappedqIDs.add(this.queryIDs.get(i));
            gappedBases.add(this.baseColumns.get(i));
            last = current;
            ++i;
        }
        this.queryIDs = gappedqIDs;
        this.baseColumns = gappedBases;
    }

    private ArrayList<Integer> getQIDs(int pos, int number) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i < number) {
            list.add(pos);
            ++i;
        }
        return list;
    }

    private StringBuffer getGaps(int number) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < number) {
            sb.append('-');
            ++i;
        }
        return sb;
    }

    public QueryBase(ArrayList<Integer> queryIDColumn, StringBuffer bases) {
        this.queryIDs.add(queryIDColumn);
        this.baseColumns.add(bases);
    }

    public int length() {
        return this.queryIDs.size();
    }
}

