/*
 * Decompiled with CFR 0.152.
 */
package buildTreesFromSequenceData;

import buildTreesFromSequenceData.AnalyseDeletedSites;
import buildTreesFromSequenceData.Clashes;
import buildTreesFromSequenceData.CutUpSequences;
import buildTreesFromSequenceData.DetermineCoreGenome;
import buildTreesFromSequenceData.GetPolymorphismWithGaps;
import buildTreesFromSequenceData.GetPolymorphisms;
import buildTreesFromSequenceData.MoveSeqToTop;
import buildTreesFromSequenceData.PerformBowtie;
import buildTreesFromSequenceData.PerformSoap;
import buildTreesFromSequenceData.RealphyException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import rcaller.RCode;
import util.Fasta;
import util.FileHandler;
import util.ObjectIO;
import util.R_functions;
import util.ReadGenbank;
import util.phylogenetics.RunTreePrograms;

public class RealPhy {
    static String version = "v1.13";
    public static final String[] fasExt = new String[]{"fas", "fa", "fasta", "fna", "fsa"};
    public static final String[] gbkExt = new String[]{"gbk", "gb", "gbff"};
    public static final String[] fastqExt = new String[]{"fastq", "fq"};
    public static final String[] gzExt = new String[]{"fastq.gz"};
    File sequenceFolder = null;
    File outFolder = null;
    File alignmentFolder = null;
    File masterOutFolder = null;
    File mergeFolder = null;
    ArrayList<String> reflist = new ArrayList();
    boolean clean;
    File config = null;
    int seedLength = 20;
    HashMap<String, Object> arguments = new HashMap();
    HashMap<String, String> path = new HashMap();
    boolean references = false;
    boolean delete = false;
    public final int bowtie2 = 1;
    public final int soap2 = 0;
    int aligner = 1;
    int perBaseCov = 10;
    boolean runAlignment = false;
    File polymorphismsOutFolder;
    int flank = 0;
    File cutFolder;
    Boolean gaps = false;
    Double gapThreshold = 0.0;
    File treeOptions = null;
    File bowtieOptions = null;
    ArrayList<String> refs;
    private static final Map<String, Boolean> novalueArgs = new HashMap<String, Boolean>();

    static {
        novalueArgs.put("h", true);
        novalueArgs.put("help", true);
        novalueArgs.put("gaps", true);
        novalueArgs.put("g", true);
        novalueArgs.put("merge", true);
        novalueArgs.put("m", true);
        novalueArgs.put("d", true);
        novalueArgs.put("delete", true);
        novalueArgs.put("varOnly", true);
        novalueArgs.put("v", true);
        novalueArgs.put("quiet", true);
        novalueArgs.put("q", true);
        novalueArgs.put("clean", true);
        novalueArgs.put("c", true);
        novalueArgs.put("genes", true);
        novalueArgs.put("version", true);
    }

    public static void main(String[] args) throws RealphyException {
        long l = System.currentTimeMillis();
        if (args.length > 1) {
            RealPhy bt = new RealPhy(args);
            if (((Boolean)bt.arguments.get("merge")).booleanValue()) {
                bt.mergeAnalyses();
            } else {
                bt.runAnalyses();
            }
            bt.analyseDeletedSites();
        } else if (args.length > 0 && args[0].equals("-version")) {
            RealPhy.printVersion();
        } else {
            RealPhy.printHelp();
        }
        long l2 = System.currentTimeMillis();
        double minutes = (double)(l2 - l) / 60000.0;
        System.out.println("Program execution took " + minutes + " minutes.");
    }

    public void analyseDeletedSites() {
        String RscriptExecutable = this.getRscript();
        double polT = 0.9;
        if (RscriptExecutable != null) {
            AnalyseDeletedSites ads = new AnalyseDeletedSites(this.perBaseCov, polT, this.polymorphismsOutFolder);
            File deletedSitesHist = new File(this.polymorphismsOutFolder + "/deletedSitesHist.jpg");
            File deletedSitesAbovePol = new File(this.polymorphismsOutFolder + "/deletedSitesAbovePolT" + polT + ".txt");
            ads.plotHistograms(deletedSitesHist, new File(RscriptExecutable));
            ads.writeDeletedAbovePolT(deletedSitesAbovePol);
        }
    }

    public static void printVersion() {
        System.out.println("This is REALPHY version " + version + ".");
        System.exit(0);
    }

    public static void printHelp() {
        System.out.print("Usage:\njava -Xmx[available RAM in MB]m -jar RealPhy_" + version + ".jar [Sequence folder] [Output folder] [Options]\n" + "Sequence folder needs to contain fasta files ending with .fas, .fna, .fasta or .fa, genbank files ending in .gbk or .gb and short read files in fastq format ending in .fastq or fastq.gz.\n" + "The output folder needs to contain a file called \"config.txt\", which contains information about the location of the required executables such as bowtie2.\n\n" + "Options:\n" + "-readLength [integer] default=50 Possible values: Integer greater than 30; Size of fragments that are to be produced from the FASTA/GBK input sequences. With longer read lengths the mapping will take longer but will also map more divergent sequences.\n" + "-quality [integer] default=20; Possible values: Integer value between 0 and 41 that corresponds to quality values in fastq files (PHRED+33). Bases with values below thresold in fastq file will not be considered (fasta files will be converted into fastq files with a quality of 20).\n" + "-polyThreshold [double] default=0.95; Possible values: Double value between 0 and 1.  Polymorphisms that occur at lower frequency than the specified threshold at any given position of the alignment will not be considered.\n" + "-perBaseCov [integer] default=10; Possible values: Integer greater than or equal to 10.  Polymorphisms will only be extracted for regions that are covered by more than the set threshold of reads.\n" + "-ref [sequence file name (without extension or path!)] default=random; Possible values: The file name of a sequence data set without the extension (.fas, .fasta, .fa, .fna, .fastq, .fastq.gz, .gb or .gbk). Sets the reference sequence.\n" + "-root [sequence file name (without extension or path!)] default=random; Possible values: The file name of a sequence data set without the extension (.fas, .fasta, .fa, .fna, .fastq, .fastq.gz, .gb or .gbk).  Specifies the root of the tree.\n" + "-refN [sequence file name (without extension or path!)] where N is the n-th reference genome; default=not set; Possible values: The file name of a sequence data set without the extension (.fas, .fasta, .fa, .fna, .fastq, .fastq.gz, .gb or .gbk).\n" + "-genes If set then genes (CDS) are extracted from a given genbank file.\n" + "-gapThreshold [double] default=0; specifies the proportion of input sequences that are allowed to contain gaps in the final sequence alignment (i.e. if set to 0.2 at most 20% of all nucleotides in each final alignment column are allowed to be gaps).\n" + "-clean/-c If set then the whole analysis will be rerun and existing data will be overwritten!\n" + "-treeBuilder [integer] default=4;\n" + "   0=Do not build a tree;\n" + "   1=treepuzzle; \n" + "   2=raxml\n" + "   3=max. parsimony (dnapars)\n" + "   4=PhyML (default)\n" + "-quiet/-q If set then it suppresses any program output except for errors or warnings.\n" + "-varOnly/-v If set then homologous positions that are conserved in all input sequences are put out. If set then the reconstructed tree may be wrong.\n" + "-seedLength [integer] default=22 Possible values: Integer between 4 and 32; specifies k-mer length in bowtie2.\n" + "-suffix [string] default=not set; appends a suffix to the reference output folder.\n" + "-d/-delete If this option is set then all alignment output files and sequence cut files will be deleted after the program is terminated.\n" + "-merge/-m If this option is set multiple references are selected, a final polymorphism file will be generated which combines all polymorphism files for all references. \n" + "-gaps/-g If this option is set. The gapThreshold is automatically set to 100%, unless a different gapThreshold is specified.\n" + "-config [string] this specifies the location of the config.txt. If not set it is assumed that the config.txt is in the working directory.\n" + "-treeOptions [text file] This option allows the user to provide command line parameters to the tree program in the first line of a given text file.\n" + "-bowtieOptions [text file] This option allows the user to provide command line parameters to bowtie2 in the first line of a given text file.\n" + "-h/-help Shows this help.\n" + "-version Prints the program's version.\n");
    }

    private String getRscript() {
        String RscriptExecutable = this.path.get("Rscript");
        if (RscriptExecutable == null) {
            System.err.println("Cannot find Rscript executable. Please set \"Rscript\" in config.txt.");
            return null;
        }
        return RscriptExecutable;
    }

    public RealPhy(String[] args) {
        this.initDefault();
        try {
            this.setVariables(args);
        }
        catch (RealphyException e) {
            e.printStackTrace();
            this.writeErrorFile(e.getMessage());
            System.exit(-1);
        }
        this.checkQuiet();
        this.checkSequenceFiles();
        this.aligner = (Integer)this.arguments.get("aligner");
        this.seedLength = (Integer)this.arguments.get("seedLength");
        this.flank = (Boolean)this.arguments.get("genes") == false ? 0 : (Integer)this.arguments.get("readLength");
        this.clean = (Boolean)this.arguments.get("clean");
    }

    private void checkQuiet() {
        if (((Boolean)this.arguments.get("quiet")).booleanValue()) {
            System.setOut(new PrintStream(new OutputStream(){

                @Override
                public void write(int b) {
                }
            }));
        }
    }

    static String getId(String name) {
        String[] split = name.split("\\.");
        StringBuffer sb = new StringBuffer();
        sb.append(split[0]);
        int num = RealPhy.hasExtension(name, gzExt) ? 2 : 1;
        int i = 1;
        while (i < split.length - num) {
            sb.append("." + split[i]);
            ++i;
        }
        return sb.toString();
    }

    private void checkSequenceFiles() {
        File[] list = this.sequenceFolder.listFiles();
        HashMap<String, Boolean> hm = new HashMap<String, Boolean>();
        int i = 0;
        while (i < list.length) {
            File file = list[i];
            String name = file.getName();
            if (RealPhy.hasExtension(name, gzExt) || RealPhy.hasExtension(name, fastqExt) || RealPhy.hasExtension(name, fasExt) || RealPhy.hasExtension(name, gbkExt)) {
                String id = RealPhy.getId(name);
                if (!hm.containsKey(id)) {
                    hm.put(id, true);
                } else {
                    System.err.println("WARNING: " + file + " has the same name or the same name as another file in the sequence folder.\n If the two file names only differ in the extension (.fas, .fasta, .fa, .fna, .fastq, .fastq.gz, .gb or .gbk) only one of the files will be used for further analyses.");
                }
            }
            ++i;
        }
    }

    private void clean() {
        if (this.clean) {
            FileHandler.deleteFolder(this.cutFolder);
            FileHandler.deleteFolder(this.outFolder);
        }
    }

    public void runAnalyses() {
        ArrayList<String> arrayList = this.refs = !this.references ? this.getReference() : this.getReferences();
        if (this.refs.size() == 0) {
            if (((Boolean)this.arguments.get("genes")).booleanValue()) {
                System.err.println("ERROR: At least one .gbk file is required in the sequence folder: " + this.sequenceFolder + " (Option -genes is set.)");
                System.exit(-1);
            } else {
                System.err.println("ERROR: At least one genbank or fasta file is required in the sequence folder: " + this.sequenceFolder);
                System.exit(-1);
            }
        }
        int i = 0;
        while (i < this.refs.size()) {
            this.outFolder = new File(this.masterOutFolder + "/" + this.refs.get(i) + this.arguments.get("suffix"));
            this.clean();
            if (!this.outFolder.exists()) {
                this.outFolder.mkdir();
            }
            String genes = (Boolean)this.arguments.get("genes") == false ? "_NoGenes" : "";
            String varOnly = (Boolean)this.arguments.get("varOnly") == false ? "" : "_noInvar";
            String base = this.outFolder + "/PolySeqOut" + genes + varOnly + "/";
            this.polymorphismsOutFolder = new File(base);
            if (!this.polymorphismsOutFolder.exists()) {
                this.polymorphismsOutFolder.mkdir();
            }
            this.alignmentFolder = (Boolean)this.arguments.get("genes") == false ? new File(this.outFolder + "/alignOut_NoGenes/") : new File(this.outFolder + "/alignOut/");
            System.out.println("Preparing reference...");
            File core = (Boolean)this.arguments.get("genes") == false ? this.moveRefToCore(this.refs.get(i)) : this.determineCore(this.refs.get(i));
            ArrayList<File> missingAlignmentFiles = this.getAlignments(false);
            if (missingAlignmentFiles.size() > 0) {
                System.out.println("Cut fasta sequence files into fragments...");
                ArrayList<File> cuts = this.cutSequences();
                System.out.println("Running alignment program to align sequence fragments to reference...");
                this.runAlignmentProgram(core, cuts);
                FileHandler.deleteFolder(this.cutFolder);
            }
            ArrayList<File> alignmentFiles = this.getAlignments(true);
            System.out.println("Determine SNPs...");
            File polymorphismsFas = this.getPolymorphisms(alignmentFiles, core, this.refs.get(i));
            this.buildTree(polymorphismsFas);
            if (this.delete) {
                this.delete(alignmentFiles);
            }
            ++i;
        }
    }

    void writeErrorFile(String errormsg) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.masterOutFolder + "/error.txt"));
            bw.write(errormsg);
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private ArrayList<File> getAlignments(boolean exists) {
        ArrayList<File> al = new ArrayList<File>();
        File[] files = this.sequenceFolder.listFiles();
        int i = 0;
        while (i < files.length) {
            String name = files[i].getName();
            String suffix = this.aligner == 0 ? ".sop" : (PerformBowtie.samtoolsExist() ? ".bam" : ".sam");
            File alFile = null;
            String id = RealPhy.getId(name);
            if (RealPhy.hasExtension(name, fasExt) || RealPhy.hasExtension(name, gbkExt)) {
                alFile = new File(this.alignmentFolder + "/" + id + "_" + this.arguments.get("readLength") + "fasta" + suffix);
            } else if (RealPhy.hasExtension(name, fastqExt)) {
                alFile = new File(this.alignmentFolder + "/" + id + suffix);
            } else if (RealPhy.hasExtension(name, gzExt)) {
                alFile = new File(this.alignmentFolder + "/" + id + suffix);
            }
            if (alFile != null && !(exists ^ alFile.exists())) {
                al.add(alFile);
            }
            ++i;
        }
        return al;
    }

    File getSequenceFile(File folder, String name) {
        File temp;
        int i = 0;
        while (i < fasExt.length) {
            temp = new File(folder + "/" + name + "." + fasExt[i]);
            if (temp.exists()) {
                return temp;
            }
            ++i;
        }
        i = 0;
        while (i < gbkExt.length) {
            temp = new File(folder + "/" + name + "." + gbkExt[i]);
            if (temp.exists()) {
                return temp;
            }
            ++i;
        }
        return null;
    }

    private File moveRefToCore(String ref) {
        File core;
        File sequenceFile = this.getSequenceFile(this.sequenceFolder, ref);
        File coreFolder = new File(this.outFolder + "/core/");
        if (!coreFolder.exists()) {
            coreFolder.mkdir();
        }
        if (!(core = new File(coreFolder + "/" + ref + ".fas")).exists()) {
            System.out.println(sequenceFile + " " + core);
            this.copyFasta(sequenceFile, core);
            this.runAlignment = true;
        } else {
            this.runAlignment = false;
        }
        return core;
    }

    private void copyFasta(File from, File to) {
        ArrayList<Fasta> fas = RealPhy.hasExtension(from.getName(), gbkExt) ? new ReadGenbank(from, new String[0]).getSequence() : Fasta.readFasta(from);
        int i = 0;
        while (i < fas.size()) {
            int length = fas.get(i).getSequence().length();
            String ident = fas.get(i).getIdent().split("\\s+")[0];
            fas.get(i).setIdent(String.valueOf(ident) + " 1.." + length + " + " + ident);
            ++i;
        }
        Fasta.write(fas, to);
    }

    private ArrayList<String> getReference() {
        ArrayList<String> refIDs = new ArrayList<String>();
        File[] list = this.sequenceFolder.listFiles();
        int i = 0;
        while (i < list.length) {
            String name = list[i].getName();
            if (RealPhy.hasExtension(name, gbkExt)) {
                String id = RealPhy.getId(name);
                refIDs.add(id);
                return refIDs;
            }
            if (RealPhy.hasExtension(name, fasExt) && !((Boolean)this.arguments.get("genes")).booleanValue()) {
                String id = RealPhy.getId(name);
                refIDs.add(id);
                return refIDs;
            }
            ++i;
        }
        return refIDs;
    }

    public static boolean hasExtension(String name, String[] ext) {
        int i = 0;
        while (i < ext.length) {
            if (name.toLowerCase().endsWith("." + ext[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private ArrayList<String> getReferences() {
        ArrayList<String> refIDs = new ArrayList<String>();
        int i = 0;
        while (i < 500) {
            if (this.arguments.containsKey("ref" + i)) {
                refIDs.add(this.arguments.get("ref" + i).toString());
            }
            ++i;
        }
        if (this.arguments.containsKey("ref") && this.arguments.get("ref").toString().length() > 0) {
            refIDs.add(this.arguments.get("ref").toString());
        }
        refIDs.addAll(this.reflist);
        return refIDs;
    }

    public void mergeAnalyses() throws RealphyException {
        this.refs = !this.references ? this.getReference() : this.getReferences();
        this.mergeFolder = new File(this.masterOutFolder + "/merge/");
        if (!this.mergeFolder.exists()) {
            this.mergeFolder.mkdir();
        }
        ArrayList<File> columnCollection = new ArrayList<File>();
        int i = 0;
        while (i < this.refs.size()) {
            File columnsFile;
            this.outFolder = new File(this.masterOutFolder + "/" + this.refs.get(i) + this.arguments.get("suffix"));
            this.clean();
            if (!this.outFolder.exists()) {
                this.outFolder.mkdir();
            }
            String genes = (Boolean)this.arguments.get("genes") == false ? "_NoGenes" : "";
            String varOnly = (Boolean)this.arguments.get("varOnly") == false ? "" : "_noInvar";
            String base = this.outFolder + "/PolySeqOut" + genes + varOnly + "/";
            this.polymorphismsOutFolder = new File(base);
            if (!this.polymorphismsOutFolder.exists()) {
                this.polymorphismsOutFolder.mkdir();
            }
            this.alignmentFolder = (Boolean)this.arguments.get("genes") == false ? new File(this.outFolder + "/alignOut_NoGenes/") : new File(this.outFolder + "/alignOut/");
            File core = (Boolean)this.arguments.get("genes") == false ? this.moveRefToCore(this.refs.get(i)) : this.determineCore(this.refs.get(i));
            ArrayList<File> missingAlignmentFiles = this.getAlignments(false);
            if (missingAlignmentFiles.size() > 0) {
                System.out.println("Cut fasta sequence files into fragments...");
                ArrayList<File> cuts = this.cutSequences();
                System.out.println("Running alignment program to align sequence fragments to reference...");
                this.runAlignmentProgram(core, cuts);
            }
            if (!(columnsFile = new File(this.outFolder + "/" + this.refs.get(i) + "_columns.obj")).exists()) {
                ArrayList<File> alignmentFiles = this.getAlignments(true);
                GetPolymorphisms gps = this.getColumns(alignmentFiles, core, this.refs.get(i));
                System.out.println("Determining polymorphic columns...");
                Clashes columns = gps.calculateColumns();
                ObjectIO.writeObject(columnsFile, columns);
            }
            columnCollection.add(columnsFile);
            ++i;
        }
        File alignment = new File(this.mergeFolder + "/mergedAlignment.fas");
        if (columnCollection.size() > 0) {
            Clashes merge = new Clashes(columnCollection);
            merge.printAlignment(alignment);
        }
        System.out.println("Building merge tree...");
        this.buildTree(alignment);
    }

    public File determineCore(String ref) {
        File core;
        File outFolderCore = new File(this.outFolder + "/core/");
        if (!outFolderCore.exists()) {
            outFolderCore.mkdir();
            this.runAlignment = true;
        }
        File file = core = this.clean ? null : this.getCoreFile(outFolderCore);
        if (core == null) {
            String[] dcgArgs = new String[]{this.sequenceFolder.toString(), outFolderCore.toString(), this.arguments.get("perBaseScore").toString(), this.arguments.get("readLength").toString(), "blastn", this.arguments.get("coreGenomes").toString(), "1", this.path.get("BLAST"), this.path.get("BLASTBUILDER"), ref};
            core = DetermineCoreGenome.runDetermineCoreGenome(dcgArgs).get(0);
            this.runAlignment = true;
        }
        return core;
    }

    public ArrayList<File> cutSequences() {
        String[] cuArgs = new String[]{this.sequenceFolder.toString(), this.arguments.get("readLength").toString(), this.cutFolder.toString(), new Boolean(this.clean).toString()};
        ArrayList<File> cutSequences = CutUpSequences.runCutUpSequences(cuArgs);
        return cutSequences;
    }

    public ArrayList<File> runAlignmentProgram(File core, ArrayList<File> cutSequences) {
        if (!this.alignmentFolder.exists()) {
            this.alignmentFolder.mkdir();
        }
        try {
            ArrayList<File> alignmentFiles = this.aligner == 0 ? PerformSoap.runMultipleSoaps(core, cutSequences, this.alignmentFolder, this.path.get("SOAP"), this.path.get("SOAPBUILDER"), this.runAlignment) : PerformBowtie.runMultiple(core, cutSequences, this.alignmentFolder, this.path.get("BOWTIE2"), this.path.get("BOWTIE2BUILDER"), this.runAlignment, this.seedLength, this.bowtieOptions);
            return alignmentFiles;
        }
        catch (RealphyException e) {
            e.printStackTrace();
            this.writeErrorFile(e.getMessage());
            System.exit(-1);
            return null;
        }
    }

    public void delete(ArrayList<File> files) {
        File folder = files.get(0).getParentFile();
        int i = 0;
        while (i < files.size()) {
            if (!files.get(i).delete()) {
                System.err.println("File " + files.get(i) + " could not be deleted.");
            }
            ++i;
        }
        folder.delete();
    }

    public GetPolymorphisms getColumns(ArrayList<File> alignmentFiles, File core, String ref) {
        System.out.println("Determine polymorphisms...");
        try {
            GetPolymorphismWithGaps GPS = new GetPolymorphismWithGaps(alignmentFiles, this.refs, core, this.flank, (Integer)this.arguments.get("quality"), (Double)this.arguments.get("polyThreshold"), (Double)this.arguments.get("fractionCov"), this.perBaseCov, (Boolean)this.arguments.get("merge"), (Boolean)this.arguments.get("genes") == false, this.gapThreshold, (Boolean)this.arguments.get("varOnly") == false, this.polymorphismsOutFolder, ref);
            File polymorphismsFas = GPS.writeSequences();
            System.out.println("Building tree...");
            this.buildTree(polymorphismsFas);
            return GPS;
        }
        catch (RealphyException e) {
            e.printStackTrace();
            this.writeErrorFile(e.getMessage());
            System.exit(-1);
            return null;
        }
    }

    public File getPolymorphisms(ArrayList<File> alignmentFiles, File core, String ref) {
        try {
            GetPolymorphismWithGaps GPS = new GetPolymorphismWithGaps(alignmentFiles, this.refs, core, this.flank, (Integer)this.arguments.get("quality"), (Double)this.arguments.get("polyThreshold"), (Double)this.arguments.get("fractionCov"), this.perBaseCov, (Boolean)this.arguments.get("merge"), (Boolean)this.arguments.get("genes") == false, this.gapThreshold, (Boolean)this.arguments.get("varOnly") == false, this.polymorphismsOutFolder, ref);
            File polymorphismsFas = GPS.writeSequences();
            return polymorphismsFas;
        }
        catch (RealphyException e) {
            e.printStackTrace();
            this.writeErrorFile(e.getMessage());
            System.exit(-1);
            return null;
        }
    }

    public void buildTree(File polymorphismsFas) {
        String root = ((String)this.arguments.get("root")).split(",")[0];
        File polymorphismsMove = new File(String.valueOf(polymorphismsFas.getParent()) + "/polymorphisms_move.fas");
        int seqLength = MoveSeqToTop.move(root, polymorphismsFas, polymorphismsMove);
        polymorphismsFas.delete();
        File phylip = new File(String.valueOf(polymorphismsMove.getParent()) + "/polymorphisms_move.phy");
        int treeBuilder = (Integer)this.arguments.get("treeBuilder");
        ArrayList<Fasta> fas = Fasta.readFasta(polymorphismsMove);
        if (treeBuilder > 0 && fas.size() > 3) {
            System.out.println("Build tree...");
            File tree = null;
            if (treeBuilder == 1) {
                Fasta.writePhylip(fas, phylip, 10);
                RunTreePrograms.runTreePuzzle(phylip, this.path.get("TREEPUZZLE"));
                tree = new File(phylip + ".tree");
            } else if (treeBuilder == 2) {
                Fasta.writePhylip(fas, phylip, 100);
                int rand = (int)(Math.random() * 1000000.0);
                RunTreePrograms.runRAxML(phylip.getAbsoluteFile(), new File(this.path.get("RAXML")), seqLength, "raxml", (String)this.arguments.get("root"), (Boolean)this.arguments.get("genes") == false, this.treeOptions, rand);
                tree = new File(String.valueOf(phylip.getParent()) + "/RAxML_bestTree.raxml");
            } else if (treeBuilder == 3) {
                Fasta.writePhylip(fas, phylip, 10);
                tree = RunTreePrograms.runMaxPars(phylip.getAbsoluteFile(), new File(this.path.get("MaxPars")));
            } else if (treeBuilder == 4) {
                Fasta.writePhylip(fas, phylip, 100);
                int rand = (int)(Math.random() * 1000000.0);
                RunTreePrograms.runPhyML(phylip.getAbsoluteFile(), new File(this.path.get("PhyML")), this.treeOptions, rand);
                tree = new File(phylip + "_phyml_tree.txt");
            }
            if (tree != null) {
                this.printTree(tree);
            }
        } else if (treeBuilder > 0) {
            String errormsg = "TOO FEW SPECIES! For tree reconstruction at least four different isolates are required.";
            System.err.println("TOO FEW SPECIES! For tree reconstruction at least four different isolates are required.");
            this.writeErrorFile(errormsg);
        }
    }

    private void printTree(File tree) {
        String RscriptExecutable = this.path.get("Rscript");
        if (RscriptExecutable == null) {
            System.err.println("Cannot find Rscript executable. Please set \"Rscript\" in config.txt.");
            return;
        }
        File jpeg = new File(String.valueOf(tree.getParent()) + "/tree.jpg");
        RCode rc = R_functions.plot_InitJpg(jpeg);
        R_functions.plotTree(rc, tree);
        R_functions.runRCode(rc, new File(RscriptExecutable));
    }

    private File getCoreFile(File folder) {
        File[] list = folder.listFiles();
        int i = 0;
        while (i < list.length) {
            String file = list[i].toString();
            if (file.endsWith("Flank" + this.flank + ".fas")) {
                return list[i];
            }
            ++i;
        }
        return null;
    }

    private void initDefault() {
        this.path.put("SOAP", "soap");
        this.path.put("TREEPUZZLE", "puzzle");
        this.path.put("RAXML", "raxmlHPC-SSE3");
        this.path.put("JAVA", "java");
        this.path.put("BLAST", "blastall");
        this.path.put("BLASTBUILDER", "formatdb");
        this.path.put("SOAPBUILDER", "2bwt-builder");
        this.path.put("BOWTIE2", "bowtie2");
        this.path.put("BOWTIE2BUILDER", "bowtie2-build");
        this.path.put("MaxPars", "dnapars");
        this.path.put("PhyML", "phyml");
        this.arguments.put("readLength", new Integer(50));
        this.arguments.put("coreGenomes", new Integer(1));
        this.arguments.put("perBaseScore", new Double(1.0));
        this.arguments.put("quality", new Integer(20));
        this.arguments.put("polyThreshold", new Double(0.95));
        this.arguments.put("fractionCov", new Double(0.0));
        this.arguments.put("perBaseCov", new Integer(10));
        this.arguments.put("root", "");
        this.arguments.put("evaluateOverlaps", new Boolean(false));
        this.arguments.put("merge", new Boolean(false));
        this.arguments.put("genes", new Boolean(false));
        this.arguments.put("gapThreshold", new Double(0.0));
        this.arguments.put("treeBuilder", new Integer(4));
        this.arguments.put("clean", new Boolean(false));
        this.arguments.put("quiet", new Boolean(false));
        this.arguments.put("varOnly", new Boolean(false));
        this.arguments.put("aligner", 1);
        this.arguments.put("seedLength", 22);
        this.arguments.put("suffix", "");
        this.arguments.put("gaps", false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setVariables(String[] args) throws RealphyException {
        this.sequenceFolder = new File(args[0]);
        this.masterOutFolder = new File(args[1]);
        this.cutFolder = new File(this.sequenceFolder + "/cut/");
        int i = 2;
        while (i < args.length) {
            Object o;
            int add = 0;
            if (!args[i].startsWith("-")) {
                throw new RealphyException("Arguments have to start with \"-\". Violating argument: " + args[i] + ".");
            }
            String arg = args[i].substring(1);
            if (novalueArgs.containsKey(arg)) {
                add = 1;
                o = new Object();
                o = this.checkValue(arg, "");
                if (o == null) throw new RealphyException("Invalid value \"" + args[i + 1] + "\" for argument -" + arg + ".");
                this.arguments.put(arg, o);
            } else {
                add = 2;
                o = new Object();
                o = this.checkValue(arg, args[i + 1]);
                if (o == null) throw new RealphyException("Invalid value \"" + args[i + 1] + "\" for argument -" + arg + ".");
                this.arguments.put(arg, o);
            }
            i += add;
        }
        this.checkReference();
        File file = this.config = this.config == null ? new File(this.masterOutFolder + "/config.txt") : this.config;
        if (this.config.exists()) {
            this.readConfig(this.config);
            return;
        } else {
            System.err.println("Cannot find " + this.config + "!");
            System.exit(-1);
        }
    }

    private void checkReference() {
        int i = 0;
        while (i < 502) {
            String ref = "";
            if (this.arguments.containsKey("ref" + i) || i == 501 && this.arguments.containsKey("ref")) {
                ref = i == 501 ? (String)this.arguments.get("ref") : (String)this.arguments.get("ref" + i);
                File seqFile = this.getSequenceFile(this.sequenceFolder, ref);
                if (seqFile != null) {
                    int j;
                    boolean fas = RealPhy.hasExtension(seqFile.getName(), fasExt);
                    boolean gbk = RealPhy.hasExtension(seqFile.getName(), gbkExt);
                    if (!gbk && ((Boolean)this.arguments.get("genes")).booleanValue()) {
                        System.err.print("File called ");
                        j = 0;
                        while (j < gbkExt.length - 1) {
                            System.err.println(String.valueOf(ref) + "." + gbkExt[j] + " or ");
                            ++j;
                        }
                        System.err.println(String.valueOf(ref) + "." + gbkExt[gbkExt.length - 1] + " is required as reference with CDS information if genes is set.");
                        System.exit(-1);
                    } else if (!(fas || gbk || ((Boolean)this.arguments.get("genes")).booleanValue())) {
                        System.err.print("File called ");
                        j = 0;
                        while (j < fasExt.length - 1) {
                            System.err.print(String.valueOf(ref) + "." + fasExt[j] + " or ");
                            ++j;
                        }
                        System.err.println(String.valueOf(ref) + "." + fasExt[fasExt.length - 1] + " is required as reference.");
                        System.exit(-1);
                    }
                } else {
                    System.err.println("Cannot find reference file with the prefix: " + ref + ".");
                }
            }
            ++i;
        }
    }

    public void readConfig(File in) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(in));
            String line = "";
            while ((line = br.readLine()) != null) {
                String[] split = line.split("\\s+");
                if (line.length() < 4) continue;
                this.path.put(split[0], split[1]);
                File temp = new File(split[1]);
                if (temp.exists()) continue;
                System.err.println("Cannot find file " + temp + "!");
                if (this.aligner == 0) {
                    if (!split[0].equals("SOAP") && !split[0].equals("SOAPBUILDER")) continue;
                    System.err.println("Cannot find " + split[1] + ". The executable for " + split[0] + " is essential! Exiting.");
                    System.exit(-1);
                    continue;
                }
                if (this.aligner != 1 || !split[0].equals("BOWTIE2") && !split[0].equals("BOWTIE2BUILDER")) continue;
                System.err.println("Cannot find " + split[1] + ". The executable for " + split[0] + " is essential! Exiting.");
                System.exit(-1);
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Object checkValue(String arg, String value) {
        if (arg.equals("readLength")) {
            return this.checkInteger(arg, value, 30, Integer.MAX_VALUE);
        }
        if (arg.equals("coreGenomes")) {
            return this.checkInteger(arg, value, 1, Integer.MAX_VALUE);
        }
        if (arg.equals("perBaseScore")) {
            return this.checkDouble(arg, value, 0.0, 2.0);
        }
        if (arg.equals("quality")) {
            return this.checkInteger(arg, value, 0, 41);
        }
        if (arg.equals("polyThreshold")) {
            return this.checkDouble(arg, value, 0.0, 1.0);
        }
        if (arg.equals("fractionCov")) {
            return this.checkDouble(arg, value, 0.0, 1.0);
        }
        if (arg.equals("gapThreshold")) {
            this.gapThreshold = this.checkDouble(arg, value, 0.0, 1.0);
            return this.gapThreshold;
        }
        if (arg.equals("gaps") || arg.equals("g")) {
            this.gaps = true;
            if (this.gaps.booleanValue() && this.gapThreshold == 0.0) {
                this.gapThreshold = 1.1;
            }
            return true;
        }
        if (arg.equals("perBaseCov")) {
            Integer i = this.checkInteger(arg, value, 1, Integer.MAX_VALUE);
            if (i != null) {
                this.perBaseCov = i;
                return i;
            }
            return null;
        }
        if (arg.equals("treeBuilder")) {
            return this.checkInteger(arg, value, 0, 4);
        }
        if (arg.equals("aligner")) {
            return this.checkInteger(arg, value, 0, 1);
        }
        if (arg.equals("covWindow")) {
            return this.checkInteger(arg, value, 0, Integer.MAX_VALUE);
        }
        if (arg.equals("seedLength")) {
            return this.checkInteger(arg, value, 4, 32);
        }
        if (arg.equals("ref")) {
            this.references = true;
            return this.checkRef(value);
        }
        if (arg.equals("ref-list")) {
            this.references = true;
            return this.checkReflist(value);
        }
        if (arg.equals("root")) {
            return this.checkRoot(value);
        }
        if (arg.startsWith("ref")) {
            this.references = true;
            return this.checkRef(value);
        }
        if (arg.startsWith("config")) {
            return this.checkConfig(value);
        }
        if (arg.equals("merge") || arg.equals("m")) {
            this.arguments.put("merge", true);
            return true;
        }
        if (arg.equals("genes")) {
            this.arguments.put("genes", true);
            return true;
        }
        if (arg.startsWith("clean") || arg.equals("c")) {
            this.arguments.put("clean", true);
            return true;
        }
        if (arg.equals("quiet") || arg.equals("q")) {
            this.arguments.put("quiet", true);
            return true;
        }
        if (arg.equals("varOnly") || arg.equals("v")) {
            this.arguments.put("varOnly", true);
            return true;
        }
        if (arg.equals("suffix")) {
            return value;
        }
        if (arg.equals("d") || arg.equals("delete")) {
            this.arguments.put("d", true);
            return true;
        }
        if (arg.equals("version")) {
            RealPhy.printVersion();
            return null;
        }
        if (arg.equals("h") || arg.equals("help")) {
            RealPhy.printHelp();
            System.exit(0);
            return null;
        }
        if (arg.equals("treeOptions")) {
            this.treeOptions = this.checkFile(value);
            return this.treeOptions;
        }
        if (arg.equals("bowtieOptions")) {
            this.bowtieOptions = this.checkFile(value);
            return this.bowtieOptions;
        }
        System.err.println("Do not recognize " + arg + ".");
        return null;
    }

    public Double checkDouble(String arg, String value, double l, double u) {
        double x;
        block5: {
            block4: {
                try {
                    x = Double.parseDouble(value);
                    if (!(x < l)) break block4;
                    System.err.println(String.valueOf(arg) + " needs to be greater than " + l + ".");
                    return null;
                }
                catch (NumberFormatException e) {
                    System.err.println(String.valueOf(value) + " is not a valid double.");
                    return null;
                }
            }
            if (!(x > u)) break block5;
            System.err.println(String.valueOf(arg) + " needs to be smaller than " + u + ".");
            return null;
        }
        return x;
    }

    public Boolean checkBoolean(String bool) {
        return Boolean.parseBoolean(bool);
    }

    public String checkRoot(String root) {
        String[] temp = root.split(",");
        int i = 0;
        while (i < temp.length) {
            File tempFile = this.getSequenceFile(this.sequenceFolder, temp[i]);
            if (tempFile == null) {
                System.err.println("No file with prefix " + temp[i] + " found.");
                return null;
            }
            ++i;
        }
        return root;
    }

    public String checkRef(String ref) {
        File temp = this.getSequenceFile(this.sequenceFolder, ref);
        if (temp != null) {
            return ref;
        }
        System.err.println("No file with prefix " + ref + " exists.");
        return null;
    }

    public String checkConfig(String configString) {
        this.config = new File(configString);
        boolean conf = this.config.exists();
        if (conf) {
            return configString;
        }
        System.err.println("No file called " + configString + " exists.");
        return null;
    }

    public Boolean checkReflist(String refListFile) {
        this.reflist = this.readReferenceList(new File(refListFile));
        int i = 0;
        while (i < this.reflist.size()) {
            this.checkRef(this.reflist.get(i));
            ++i;
        }
        return true;
    }

    private ArrayList<String> readReferenceList(File in) {
        ArrayList<String> refs = new ArrayList<String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(in));
            while ((line = br.readLine()) != null) {
                refs.add(RealPhy.getId(line));
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        return refs;
    }

    public File checkFile(String file) {
        File in = new File(file);
        if (in.exists()) {
            return in;
        }
        throw new RuntimeException("File " + file + " does not exist.");
    }

    public Integer checkInteger(String arg, String value, int l, int u) {
        int x;
        block5: {
            block4: {
                try {
                    x = Integer.parseInt(value);
                    if (x >= l) break block4;
                    System.err.println(String.valueOf(arg) + " needs to be greater/equal than " + l + ".");
                    return null;
                }
                catch (NumberFormatException e) {
                    System.err.println(String.valueOf(value) + " is not a valid integer.");
                    return null;
                }
            }
            if (x <= u) break block5;
            System.err.println(String.valueOf(arg) + " needs to be smaller/equal than " + u + ".");
            return null;
        }
        return x;
    }
}

