/*
 * Decompiled with CFR 0.152.
 */
package pairwiseAlignment;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import pairwiseAlignment.NeedlemanWunsch;
import statistics.Stats;
import util.Fasta;

public class PairwiseIdentity {
    public static void main(String[] args) {
        File folder = new File(args[0]);
        File[] files = folder.listFiles();
        int k = 0;
        while (k < files.length) {
            if (files[k].getAbsolutePath().endsWith("fas") || files[k].getAbsolutePath().endsWith("fasta")) {
                System.out.println(files[k]);
                ArrayList<Fasta> fas1 = Fasta.readFasta(files[k]);
                ArrayList<Double> pw = new ArrayList<Double>();
                try {
                    BufferedWriter bw = new BufferedWriter(new FileWriter(files[k] + ".out"));
                    int i = 0;
                    while (i < fas1.size()) {
                        int j = i + 1;
                        while (j < fas1.size()) {
                            bw.write(String.valueOf(NeedlemanWunsch.getPairwiseIdentity(fas1.get(i).getSequence(), fas1.get(j).getSequence())) + "\r\n");
                            pw.add(NeedlemanWunsch.getPairwiseIdentity(fas1.get(i).getSequence(), fas1.get(j).getSequence()));
                            ++j;
                        }
                        ++i;
                    }
                    bw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(-1);
                }
                Stats stats = new Stats(pw);
                System.out.println("Average: " + stats.getAverage());
                System.out.println("Standard deviation: " + stats.getStandardDeviation());
                System.out.println("Standard error: " + stats.getStandardError());
            }
            ++k;
        }
    }
}

