/*
 * Decompiled with CFR 0.152.
 */
package solexa;

import java.io.File;
import java.util.ArrayList;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import solexa.PointSubstitutions;

public class PointSubstitutionsBAM
extends PointSubstitutions {
    private static final long serialVersionUID = 1L;

    public static void main(String[] args) {
        File refseq = new File("/home/frederic/Basel/randomAlignments/test/test2/sequences/S21.fas");
        PointSubstitutionsBAM pss = new PointSubstitutionsBAM(refseq, 0, new File("/home/frederic/Basel/randomAlignments/test/test2/S21/alignOut_NoGenes/S12_50fasta.bam"), 20, false);
        pss.writeArray(0.0, refseq, new File("/home/frederic/Basel/randomAlignments/test/test2/S21/alignOut_NoGenes/"));
    }

    public double setSubstitution(String MD, String cigar, String sequence, String readID, String qualityString, char orientation, int posorig, int flank, int quality, String fastaId, boolean subInfo, double weight) {
        ArrayList<Integer> posMismatchesRead;
        ArrayList<Integer> posMismatchesRef = PointSubstitutionsBAM.getMismatchesRef(MD);
        if (cigar.contains("I")) {
            ArrayList<Integer> refDeletions = PointSubstitutionsBAM.getRefDeletions(cigar);
            posMismatchesRead = PointSubstitutionsBAM.getMismatchesRead(MD, refDeletions);
        } else {
            posMismatchesRead = cigar.contains("D") ? PointSubstitutionsBAM.getMismatchesRead(MD) : posMismatchesRef;
        }
        return this.setSubstitutions(posMismatchesRead, posMismatchesRef, sequence, readID, qualityString, orientation, posorig, flank, quality, fastaId, subInfo, weight);
    }

    public void setGaps(String cigar, String sequence, String readID, char orientation, int posorig, int flank, String fastaId, boolean subinfo, double weight) {
        ArrayList<Integer> gapsRead = this.getGapsRead(cigar);
        ArrayList<Integer> gapsRef = this.getGapsRef(cigar, orientation);
        this.setGaps(gapsRead, gapsRef, sequence, readID, orientation, posorig, flank, fastaId, subinfo, weight);
    }

    private ArrayList<Integer> getGapsRead(String cigar) {
        String[] pos = cigar.split("[^0-9]+");
        String[] edit = cigar.split("[0-9]+");
        ArrayList<Integer> gapsPos = new ArrayList<Integer>();
        int start = 0;
        int i = 1;
        while (i < pos.length) {
            int count = Integer.parseInt(pos[i - 1]);
            if (edit[i].charAt(0) == 'D') {
                int j = 0;
                while (j < count) {
                    gapsPos.add(start);
                    ++j;
                }
            } else if (edit[i].charAt(0) == 'M' || edit[i].charAt(0) == 'I') {
                start += count;
            }
            ++i;
        }
        return gapsPos;
    }

    private ArrayList<Integer> getGapsRef(String cigar, char orient) {
        String[] pos = cigar.split("[^0-9]+");
        String[] edit = cigar.split("[0-9]+");
        ArrayList<Integer> gapsPos = new ArrayList<Integer>();
        int start = 0;
        int i = 1;
        while (i < pos.length) {
            int count = Integer.parseInt(pos[i - 1]);
            if (edit[i].charAt(0) == 'D') {
                int j = 0;
                while (j < count) {
                    gapsPos.add(start + j);
                    ++j;
                }
                start += count;
            } else if (edit[i].charAt(0) == 'M') {
                start += count;
            }
            ++i;
        }
        return gapsPos;
    }

    /*
     * Unable to fully structure code
     */
    public double setCoverageCigar(StringBuffer regionsRef, StringBuffer regionsRead, int length, int pos, String fastaId, String sequence, String qualityString, int quality, char orientation, boolean subInfo, String readID, double weight, int flank) {
        block11: {
            block10: {
                ret = 0.0;
                size = regionsRef.length();
                readPos = -1;
                posorig = pos;
                gap = true;
                if (orientation != '+') break block10;
                i = 0;
                ** GOTO lbl24
                {
                    ++readPos;
                    regionsRead.deleteCharAt(i);
                    do {
                        if (regionsRead.charAt(i) == 's') continue block0;
                        if (regionsRead.charAt(i) == 'm') {
                            ++readPos;
                            gap = false;
                        }
                        if (regionsRef.charAt(i) == 'm') {
                            this.setCoverageSingle(pos, readPos, fastaId, sequence, qualityString, quality, orientation, subInfo, readID, weight, gap);
                            if (gap) {
                                this.setGap(sequence, readPos, pos - posorig, readID, orientation, posorig, fastaId, subInfo, weight);
                            }
                            ++pos;
                        }
                        gap = true;
                        ++i;
lbl24:
                        // 2 sources

                    } while (i < size);
                }
                break block11;
            }
            this.deleteSFromBeginning(regionsRead);
            i = size - 1;
            ** GOTO lbl45
            {
                ++readPos;
                regionsRead.deleteCharAt(regionsRead.length() - 1);
                do {
                    if (regionsRead.charAt(regionsRead.length() - 1) == 's') continue block2;
                    if (regionsRead.charAt(i) == 'm') {
                        ++readPos;
                        gap = false;
                    }
                    if (regionsRef.charAt(i) == 'm') {
                        this.setCoverageSingle(pos, readPos, fastaId, sequence, qualityString, quality, orientation, subInfo, readID, weight, gap);
                        if (gap) {
                            this.setGap(sequence, readPos, pos - posorig, readID, orientation, posorig, fastaId, subInfo, weight);
                        }
                        ++pos;
                    }
                    gap = true;
                    --i;
lbl45:
                    // 2 sources

                } while (i >= 0);
            }
        }
        return ret;
    }

    private void deleteSFromBeginning(StringBuffer s) {
        while (s.charAt(0) == 's') {
            s.deleteCharAt(0);
        }
    }

    public double setSubstitutions(ArrayList<Integer> posMismatchesRead, ArrayList<Integer> posMismatchesRef, String sequence, String readID, String qualityString, char orientation, int posorig, int flank, int quality, String fastaId, boolean subInfo, double weight) {
        double ret = 0.0;
        int j = 0;
        while (j < posMismatchesRead.size()) {
            int mismatchRead = posMismatchesRead.get(j) - 1;
            int mismatchRef = posMismatchesRef.get(j) - 1;
            double t = 0.0;
            t = this.setSubstitution(sequence, mismatchRead, mismatchRef, readID, qualityString, orientation, posorig, quality, fastaId, subInfo, weight);
            if (t != 0.0) {
                ret = t;
            }
            ++j;
        }
        return ret;
    }

    public void setGaps(ArrayList<Integer> posGapsRead, ArrayList<Integer> posGapsRef, String sequence, String readID, char orientation, int posorig, int flank, String fastaId, boolean subInfo, double weight) {
        int j = 0;
        while (j < posGapsRef.size()) {
            int gapRead = posGapsRead.get(j);
            int gapRef = posGapsRef.get(j);
            this.setGap(sequence, gapRead, gapRef, readID, orientation, posorig, fastaId, subInfo, weight);
            ++j;
        }
    }

    public PointSubstitutionsBAM(File RefSeq, int flank, File AlignmentFile, int quality, int fold, boolean subInfo) {
        super(RefSeq, flank, AlignmentFile, quality, fold, subInfo);
    }

    public PointSubstitutionsBAM(File RefSeq, int flank, File AlignmentFile, int quality, boolean subInfo) {
        this(RefSeq, flank, AlignmentFile, quality, 1, subInfo);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    @Override
    void read(int quality, int fold) {
        sfr = new SAMFileReader(this.alignmentFile, true);
        sri = sfr.iterator();
        p = 1.0 / (double)fold;
        srnext = null;
        while (sri.hasNext()) {
            block5: {
                block4: {
                    if (p < 1.0 && Math.random() > p) {
                        sri.next();
                        continue;
                    }
                    sams = new ArrayList<SAMRecord>();
                    sams.add(srnext != null ? srnext : (SAMRecord)sri.next());
                    sr = srnext;
                    if (sr.getAttribute("AS") == null) break block4;
                    AS = (Integer)sr.getAttribute("AS");
                    if (true) ** GOTO lbl27
                }
                srnext = (SAMRecord)sri.next();
                break block5;
                do {
                    ASnext = (Integer)srnext.getAttribute("AS");
                    v0 = readPair = sr.getReadPairedFlag() != false && sr.getFirstOfPairFlag() != false && srnext.getSecondOfPairFlag() != false;
                    if (AS == ASnext || readPair) {
                        sams.add(srnext);
                    }
                    sr = srnext;
lbl27:
                    // 2 sources

                    if (!sri.hasNext()) break;
                    srnext = (SAMRecord)sri.next();
                } while (sr.getReadName().equals(srnext.getReadName()));
            }
            this.analyseAll(sams, quality, this.flank);
        }
        sri.close();
        sfr.close();
    }

    private void analyseAll(ArrayList<SAMRecord> sams, int quality, int flank) {
        double weight = 1.0 / ((double)sams.size() * 1.0);
        int i = 0;
        while (i < sams.size()) {
            this.analyseLine(sams.get(i), flank, quality, weight);
            ++i;
        }
    }

    private void analyseLine(SAMRecord sr, int flank, int quality, double weight) {
        Object MD;
        if (sr.getReadPairedFlag() && sr.getProperPairFlag()) {
            weight *= 2.0;
        }
        if (weight > 1.0) {
            System.err.println("Weight is too large (>1): " + weight + " for read " + sr.getReadName() + " in file " + this.alignmentFile + ".");
            System.exit(-1);
        }
        String cigar = sr.getCigarString();
        int length = sr.getReadLength();
        String qualityString = sr.getBaseQualityString();
        String fastaId = sr.getReferenceName();
        String sequence = sr.getReadString();
        char orientation = sr.getReadNegativeStrandFlag() ? (char)'-' : '+';
        String readID = sr.getReadName();
        int posorig = sr.getAlignmentStart();
        int pos = posorig;
        if (pos <= flank) {
            length = pos + length - flank - 1;
            pos = 1;
        } else {
            pos -= flank;
        }
        Object XM = sr.getAttribute("XM");
        StringBuffer regionsRef = new StringBuffer();
        StringBuffer regionsRead = new StringBuffer();
        PointSubstitutionsBAM.getMatchRegionsCigar(cigar, regionsRead, regionsRef);
        StringBuffer MDgen = new StringBuffer();
        if (!cigar.equals(String.valueOf(length) + "M")) {
            double c = this.setCoverageCigar(regionsRef, regionsRead, length, pos, fastaId, sequence, qualityString, quality, orientation, this.subInfo, readID, weight, flank);
        } else {
            double c = this.setCoverage(pos, length, fastaId, sequence, qualityString, quality, orientation, this.subInfo, readID, weight);
        }
        if ((XM != null && (Integer)XM > 0 || sr.getAttribute("RG") != null && sr.getAttribute("RG").equals("Unpaired_reads_assembled_against_NL43_ann_wk0virusPassRef")) && (MD = sr.getAttribute("MD")) != null) {
            this.setSubstitution(MD.toString(), cigar, sequence, readID, qualityString, orientation, posorig, flank, quality, fastaId, this.subInfo, weight);
        }
    }
}

