/*
 * Decompiled with CFR 0.152.
 */
package solexa;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import solexa.PointSubstitutions;

public class PointSubstitutionsSoap
extends PointSubstitutions
implements Serializable {
    private static final long serialVersionUID = 1L;

    public PointSubstitutionsSoap(File RefSeq, int flank, File AlignmentFile, int quality, int fold, boolean subInfo) {
        super(RefSeq, flank, AlignmentFile, quality, fold, subInfo);
    }

    public PointSubstitutionsSoap(File RefSeq, int flank, File AlignmentFile, int quality, boolean subInfo) {
        this(RefSeq, flank, AlignmentFile, quality, 1, subInfo);
    }

    public static void main(String[] args) {
        File soap = new File(args[0]);
        File RefSeq = new File(args[1]);
        double threshold = Double.parseDouble(args[2]);
        File outDir = new File(args[3]);
        int quality = Integer.parseInt(args[4]);
        int flank = Integer.parseInt(args[5]);
        PointSubstitutionsSoap PS = new PointSubstitutionsSoap(RefSeq, flank, soap, quality, false);
        PS.writeArray(threshold, RefSeq, outDir);
    }

    @Override
    void read(int quality, int fold) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.alignmentFile));
            String line = "";
            double p = 1.0 / (double)fold;
            while ((line = br.readLine()) != null) {
                String[] data;
                if (Math.random() > p || Integer.parseInt((data = line.split("\\s+"))[3]) > 1) continue;
                String fastaId = data[7];
                char orientation = data[6].charAt(0);
                int posorig = Integer.parseInt(data[8]);
                int length = Integer.parseInt(data[5]);
                int pos = posorig;
                String sequence = data[1];
                String readID = data[0];
                String qualityString = data[2];
                if (pos <= this.flank) {
                    length = pos + length - this.flank - 1;
                    pos = 1;
                } else {
                    pos -= this.flank;
                }
                if (!this.coverage.containsKey(fastaId)) {
                    System.err.println("The reference name in the soap alignment file is " + fastaId + ". There is no such reference name in the genbank or fasta file.\nExiting!");
                    System.exit(-1);
                }
                this.setCoverage(pos, length, fastaId, sequence, qualityString, quality, orientation, this.subInfo, readID, 1.0);
                int numSubs = Integer.parseInt(data[9]);
                int j = 0;
                while (j < numSubs) {
                    String[] split = data[10 + j].split("[^0-9]+");
                    int readSubPos = Integer.parseInt(split[1]);
                    this.setSubstitution(sequence, readSubPos, readSubPos, readID, qualityString, orientation, posorig, quality, fastaId, this.subInfo, 1.0);
                    ++j;
                }
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

