/*
 * Decompiled with CFR 0.152.
 */
package statistics;

import java.util.ArrayList;
import java.util.Collections;

public class Stats {
    private ArrayList<Double> listX = new ArrayList();
    private ArrayList<Double> listY = new ArrayList();
    ArrayList<ArrayList<Double>> binsX = new ArrayList();
    ArrayList<ArrayList<Double>> binsY = new ArrayList();
    ArrayList<Double> binsYMean = new ArrayList();
    ArrayList<Double> binsYStdv = new ArrayList();
    ArrayList<Double> binsYStdErr = new ArrayList();
    ArrayList<Double> binsXMean = new ArrayList();
    private double stdDev;
    private double avg;
    private boolean meanCalc;
    private boolean stdvCalc;
    boolean twoLists = false;
    boolean binned = false;
    double binSize;
    int NumBins;

    public Stats(ArrayList<Double> List2) {
        this.listX = List2;
        this.meanCalc = false;
        this.stdvCalc = false;
    }

    public ArrayList<Double> getList() {
        return this.listX;
    }

    public static ArrayList<Double> toArrayList(double[] list) {
        ArrayList<Double> newList = new ArrayList<Double>();
        int i = 0;
        while (i < list.length) {
            newList.add(list[i]);
            ++i;
        }
        return newList;
    }

    public Stats(double[] List2) {
        this.listX = Stats.toArrayList(List2);
        this.meanCalc = false;
        this.stdvCalc = false;
    }

    public Stats(ArrayList<Double> x, ArrayList<Double> y) {
        this.listX = x;
        this.listY = y;
        this.meanCalc = false;
        this.stdvCalc = false;
        this.twoLists = true;
    }

    public static double getMin(double[] all) {
        double min = all[0];
        int i = 0;
        while (i < all.length) {
            if (min > all[i]) {
                min = all[i];
            }
            ++i;
        }
        return min;
    }

    public static double getMin(ArrayList<Double> all) {
        double min = all.get(0);
        int i = 0;
        while (i < all.size()) {
            if (min > all.get(i)) {
                min = all.get(i);
            }
            ++i;
        }
        return min;
    }

    public static double getMax(double[] all) {
        double max = all[0];
        int i = 0;
        while (i < all.length) {
            if (max < all[i]) {
                max = all[i];
            }
            ++i;
        }
        return max;
    }

    public static double getMax(ArrayList<Double> all) {
        double max = all.get(0);
        int i = 0;
        while (i < all.size()) {
            if (max < all.get(i)) {
                max = all.get(i);
            }
            ++i;
        }
        return max;
    }

    private ArrayList<CoupledEntry> makeList() {
        ArrayList<CoupledEntry> ce = new ArrayList<CoupledEntry>();
        int i = 0;
        while (i < this.listX.size()) {
            ce.add(new CoupledEntry(this.listX.get(i), this.listY.get(i)));
            ++i;
        }
        return ce;
    }

    private void sortLists() {
        ArrayList<CoupledEntry> al = this.makeList();
        Collections.sort(al);
        this.listX = new ArrayList();
        this.listY = new ArrayList();
        int i = 0;
        while (i < al.size()) {
            this.listX.add(al.get((int)i).x);
            this.listY.add(al.get((int)i).y);
            ++i;
        }
    }

    private void binData() {
        if (this.twoLists) {
            this.binned = true;
            this.binSize = this.listX.size() / this.NumBins;
            int j = -1;
            this.sortLists();
            int i = 0;
            while (i < this.listX.size()) {
                if ((double)i >= (double)(j + 1) * this.binSize) {
                    this.binsX.add(new ArrayList());
                    this.binsY.add(new ArrayList());
                    ++j;
                }
                this.binsX.get(j).add(this.listX.get(i));
                this.binsY.get(j).add(this.listY.get(i));
                ++i;
            }
            this.calculateBinsStats();
        } else {
            System.err.println("For a single list binning is not implemented yet.");
        }
    }

    private void calculateBinsStats() {
        int size = this.binsY.size();
        int i = 0;
        while (i < size) {
            Stats s = new Stats(this.binsY.get(i));
            this.binsYMean.add(s.getAverage());
            this.binsYStdv.add(s.getStandardDeviation());
            this.binsYStdErr.add(s.getStandardError());
            s = new Stats(this.binsX.get(i));
            this.binsXMean.add(s.getAverage());
            ++i;
        }
    }

    public ArrayList<Double> getBinsYStdDev(int numBins) {
        this.runBinning(numBins);
        return this.binsYStdv;
    }

    public ArrayList<Double> getBinsYStdErr(int numBins) {
        this.runBinning(numBins);
        return this.binsYStdErr;
    }

    public ArrayList<Double> getBinsYMean(int numBins) {
        this.runBinning(numBins);
        return this.binsYMean;
    }

    public ArrayList<Double> getBinsXMean(int numBins) {
        this.runBinning(numBins);
        return this.binsXMean;
    }

    public ArrayList<ArrayList<Double>> getBinsX(int numBins) {
        this.runBinning(numBins);
        return this.binsX;
    }

    public ArrayList<ArrayList<Double>> getBinsY(int numBins) {
        this.runBinning(numBins);
        return this.binsY;
    }

    public ArrayList<ArrayList<Double>> getBinsX() {
        return this.binsX;
    }

    public ArrayList<ArrayList<Double>> getBinsY() {
        return this.binsY;
    }

    private void runBinning(int numBins) {
        if (!this.binned && this.twoLists) {
            this.NumBins = numBins;
            this.binData();
        } else if (this.binned && this.twoLists && numBins != this.NumBins) {
            this.NumBins = numBins;
            this.binData();
        }
    }

    public double getBinSize() {
        if (this.binned) {
            return this.binSize;
        }
        System.err.println("Data has not been binned yet. Please run binData(double numBins) first.");
        return -1.0;
    }

    public ArrayList<Integer> getIndexListBelowDoubleStdv() {
        ArrayList<Integer> indeces = new ArrayList<Integer>();
        if (!this.meanCalc) {
            this.calculateMean();
            this.meanCalc = true;
        }
        if (!this.stdvCalc) {
            this.calculateStdDev();
            this.stdvCalc = true;
        }
        int i = 0;
        while (i < this.listX.size()) {
            if (this.listX.get(i) < this.avg - this.stdDev * 2.0) {
                indeces.add(i);
            }
            ++i;
        }
        return indeces;
    }

    public ArrayList<Integer> getIndexListAboveDoubleStdv() {
        ArrayList<Integer> indeces = new ArrayList<Integer>();
        if (!this.meanCalc) {
            this.calculateMean();
            this.meanCalc = true;
        }
        if (!this.stdvCalc) {
            this.calculateStdDev();
            this.stdvCalc = true;
        }
        int i = 0;
        while (i < this.listX.size()) {
            if (this.listX.get(i) > this.stdDev * 2.0 + this.avg) {
                indeces.add(i);
            }
            ++i;
        }
        return indeces;
    }

    public double unexplainedVar() {
        double avg = this.getAverage();
        double sum = 0.0;
        int i = 0;
        while (i < this.listX.size()) {
            sum += Math.pow(avg - this.listX.get(i), 2.0);
            ++i;
        }
        return sum / (double)(this.listX.size() - 2);
    }

    private void calculateMean() {
        double sum = 0.0;
        int i = 0;
        while (i < this.listX.size()) {
            sum += this.listX.get(i).doubleValue();
            ++i;
        }
        this.avg = sum / (double)this.listX.size();
    }

    private void calculateStdDev() {
        double help = 0.0;
        int i = 0;
        while (i < this.listX.size()) {
            help += Math.pow(this.listX.get(i) - this.avg, 2.0);
            ++i;
        }
        this.stdDev = Math.sqrt(help / (double)this.listX.size());
    }

    public double getStandardError() {
        if (!this.meanCalc) {
            this.calculateMean();
            this.calculateStdDev();
            this.meanCalc = true;
            this.stdvCalc = true;
        } else if (!this.stdvCalc) {
            this.calculateStdDev();
            this.stdvCalc = true;
        }
        return this.stdDev / Math.sqrt(this.listX.size());
    }

    public double getStandardDeviation() {
        if (!this.meanCalc) {
            this.calculateMean();
            this.meanCalc = true;
        }
        if (!this.stdvCalc) {
            this.calculateStdDev();
            this.stdvCalc = true;
        }
        return this.stdDev;
    }

    public double getAverage() {
        if (!this.meanCalc) {
            this.meanCalc = true;
            this.calculateMean();
        }
        return this.avg;
    }

    public class CoupledEntry
    implements Comparable<CoupledEntry> {
        double x;
        double y;

        @Override
        public int compareTo(CoupledEntry e) {
            return this.x < e.x ? -1 : (this.x == e.x ? 0 : 1);
        }

        public CoupledEntry(double X, double Y) {
            this.x = X;
            this.y = Y;
        }
    }
}

