/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.ArrayList;
import statistics.Stats;

public class BinLength {
    ArrayList<ArrayList<Double>> bins = new ArrayList();
    boolean binned = false;
    boolean binStats = false;
    ArrayList<Double> binContentHistX = new ArrayList();
    ArrayList<Double> binContentHistY = new ArrayList();
    Stats binContentHistStats;
    double binSize;
    int NumBins;
    ArrayList<Double> list;

    public BinLength(ArrayList<Double> List2) {
        this.list = List2;
    }

    private void initBin(ArrayList<ArrayList<Double>> bins) {
        int i = 0;
        while (i < this.NumBins) {
            bins.add(new ArrayList());
            ++i;
        }
    }

    private void calculateBinsStats() {
        this.binStats = true;
        int size = this.bins.size();
        int i = 0;
        while (i < size) {
            int numElements = this.bins.get(i).size();
            this.binContentHistY.add((double)numElements + 0.0);
            this.binContentHistStats = new Stats(this.binContentHistY);
            ++i;
        }
    }

    private void makeXValues(double min, double binSize) {
        int i = 0;
        while (i < this.NumBins) {
            this.binContentHistX.add(min + (double)i * binSize);
            ++i;
        }
    }

    private void binData() {
        this.binned = true;
        double min = Stats.getMin(this.list);
        double max = Stats.getMax(this.list);
        this.binSize = (max - min) / (double)this.NumBins;
        this.initBin(this.bins);
        this.makeXValues(min, this.binSize);
        int i = 0;
        while (i < this.list.size()) {
            double entry = this.list.get(i);
            int bin = (int)((entry - min) / this.binSize);
            if (bin == this.NumBins) {
                --bin;
            }
            this.bins.get(bin).add(this.list.get(i));
            ++i;
        }
        this.calculateBinsStats();
    }

    public Stats getBinContentStatsLength(int numBins) {
        if (this.binStats && numBins == this.NumBins) {
            return this.binContentHistStats;
        }
        this.NumBins = numBins;
        this.binData();
        return this.binContentHistStats;
    }

    public ArrayList<Double> getBinsSizesPositionX(int numBins) {
        if (!this.binned) {
            this.runBinning(numBins);
        }
        return this.binContentHistX;
    }

    public ArrayList<Double> getBinSizes(int numBins) {
        if (!this.binned) {
            this.runBinning(numBins);
        }
        return this.binContentHistY;
    }

    private void runBinning(int numBins) {
        if (!this.binned || numBins != this.NumBins) {
            this.NumBins = numBins;
            this.binData();
        }
    }
}

