/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import util.Fasta;

public class DNAmanipulations {
    public static String reverse(String seq) {
        StringBuilder sb = new StringBuilder();
        seq = seq.toUpperCase();
        int i = seq.length() - 1;
        while (i > -1) {
            sb.append((char)(seq.charAt(i) == 'A' ? 84 : (seq.charAt(i) == 'T' ? 65 : (seq.charAt(i) == 'C' ? 71 : (seq.charAt(i) == 'G' ? 67 : 78)))));
            --i;
        }
        return sb.toString();
    }

    public static String complement(String seq) {
        StringBuilder sb = new StringBuilder();
        seq = seq.toUpperCase();
        int i = 0;
        while (i < seq.length()) {
            sb.append((char)(seq.charAt(i) == 'A' ? 84 : (seq.charAt(i) == 'T' ? 65 : (seq.charAt(i) == 'C' ? 71 : (seq.charAt(i) == 'G' ? 67 : 78)))));
            ++i;
        }
        return sb.toString();
    }

    public static String generateRandomSequence(int length, double GC) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < length) {
            sb.append(DNAmanipulations.getRandomBase(GC));
            ++i;
        }
        return sb.toString();
    }

    public static char getRandomBase(double GC) {
        double rand = Math.random();
        double r = Math.random();
        if (rand > GC) {
            if (r > 0.5) {
                return 'A';
            }
            return 'T';
        }
        if (r > 0.5) {
            return 'C';
        }
        return 'G';
    }

    public static String randomizeSequenceMutateToSelf(String seq, double mutationProb, double GC) {
        StringBuffer sb = new StringBuffer(seq);
        int seqlength = seq.length();
        int numberMutations = (int)((double)seq.length() * mutationProb);
        int i = 0;
        while (i < numberMutations) {
            int randPosition = (int)(Math.random() * (double)seqlength);
            sb.setCharAt(randPosition, DNAmanipulations.getMutationSelfMutate(seq.charAt(randPosition), GC));
            ++i;
        }
        return sb.toString();
    }

    public static String randomizeSequence(String seq, double mutationProb, double GC) {
        StringBuffer sb = new StringBuffer(seq);
        int seqlength = seq.length();
        int numberMutations = (int)((double)seq.length() * mutationProb);
        int i = 0;
        while (i < numberMutations) {
            int randPosition = (int)(Math.random() * (double)seqlength);
            sb.setCharAt(randPosition, DNAmanipulations.getMutation(seq.charAt(randPosition), GC));
            ++i;
        }
        return sb.toString();
    }

    public static String randomizeSequenceSelfMutate(String seq, double mutationProb, double GC) {
        StringBuffer sb = new StringBuffer(seq);
        int seqlength = seq.length();
        int numberMutations = (int)((double)seq.length() * mutationProb);
        int i = 0;
        while (i < numberMutations) {
            int randPosition = (int)(Math.random() * (double)seqlength);
            sb.setCharAt(randPosition, DNAmanipulations.getMutationSelfMutate(seq.charAt(randPosition), GC));
            ++i;
        }
        return sb.toString();
    }

    public static char getMutationSelfMutate(char in, double GC) {
        char base = DNAmanipulations.getRandomBase(GC);
        return base;
    }

    public static char getMutation(char in, double GC) {
        boolean mut = false;
        while (!mut) {
            char base = DNAmanipulations.getRandomBase(GC);
            if (in == base) continue;
            return base;
        }
        return '\u0000';
    }

    public static BitSet mutate(BitSet seq, int pos, int mutation) {
        BitSet mut = new BitSet();
        mut.or(seq);
        if (pos % 2 == 1) {
            System.err.println("Position is wrong, has to be dividable by two!");
        } else if (mut.get(pos) != (mutation % 2 == 0) || mut.get(pos + 1) != (mutation / 2 % 2 == 0)) {
            mut.set(pos, mutation % 2 == 0);
            mut.set(pos + 1, mutation / 2 % 2 == 0);
            return mut;
        }
        return new BitSet();
    }

    public static BitSet reverse(BitSet code) {
        BitSet rev = new BitSet();
        int j = 0;
        int i = code.length() - 3;
        while (i > -1) {
            if (!code.get(i) && !code.get(i + 1)) {
                rev.set(j * 2, false);
                rev.set(j * 2 + 1, true);
            } else if (!code.get(i) && code.get(i + 1)) {
                rev.set(j * 2, false);
                rev.set(j * 2 + 1, false);
            } else if (code.get(i) && !code.get(i + 1)) {
                rev.set(j * 2, true);
                rev.set(j * 2 + 1, true);
            } else if (code.get(i) && code.get(i + 1)) {
                rev.set(j * 2, true);
                rev.set(j * 2 + 1, false);
            }
            ++j;
            i -= 2;
        }
        rev.set(j * 2, true);
        return rev;
    }

    public static BitSet flip(BitSet code) {
        BitSet rev = new BitSet();
        int j = 0;
        int i = code.length() - 3;
        while (i > -1) {
            rev.set(j * 2, code.get(i));
            rev.set(j * 2 + 1, code.get(i + 1));
            ++j;
            i -= 2;
        }
        rev.set(j * 2, true);
        return rev;
    }

    public static BitSet append(BitSet b1, BitSet b2) {
        int b1size = b1.length();
        int b2size = b2.length();
        if (b1size == 0) {
            return b2;
        }
        int i = b1size - 1;
        while (i < b1size + b2size) {
            b1.set(i, b2.get(i - b1size + 1));
            ++i;
        }
        return b1;
    }

    public static int next(BitSet reference, BitSet search, int from) {
        int pos = -1;
        if (from % 2 != 0) {
            System.err.println("\"From\" has to be dividable by 2!");
            return -1;
        }
        int i = from;
        while (i < reference.length() - search.length() + 1) {
            if (DNAmanipulations.get(reference, i, i + search.length() - 1).equals(search)) {
                return i;
            }
            i += 2;
        }
        return pos;
    }

    public static BitSet get(BitSet b, int start, int end) {
        if (end >= b.length()) {
            end = b.length() - 1;
        }
        if (start >= b.length()) {
            return new BitSet();
        }
        BitSet nB = b.get(start, end);
        nB.set(end - start);
        return nB;
    }

    public static String translate(String DNA, HashMap<String, String> code) {
        StringBuilder AA = new StringBuilder("");
        int i = 0;
        while (i < DNA.length() - 2) {
            AA.append(code.get(DNA.substring(i, i + 3).toUpperCase()));
            i += 3;
        }
        return AA.toString();
    }

    public static HashMap<String, String> code() {
        HashMap<String, String> code = new HashMap<String, String>();
        code.put("TTT", "F");
        code.put("TTC", "F");
        code.put("TTG", "L");
        code.put("TTA", "L");
        code.put("CTT", "L");
        code.put("CTC", "L");
        code.put("CTA", "L");
        code.put("CTG", "L");
        code.put("ATT", "I");
        code.put("ATC", "I");
        code.put("ATA", "I");
        code.put("ATG", "M");
        code.put("GTT", "V");
        code.put("GTC", "V");
        code.put("GTA", "V");
        code.put("GTG", "V");
        code.put("TCT", "S");
        code.put("TCC", "S");
        code.put("TCA", "S");
        code.put("TCG", "S");
        code.put("CCT", "P");
        code.put("CCC", "P");
        code.put("CCA", "P");
        code.put("CCG", "P");
        code.put("ACT", "T");
        code.put("ACC", "T");
        code.put("ACA", "T");
        code.put("ACG", "T");
        code.put("GCT", "A");
        code.put("GCC", "A");
        code.put("GCA", "A");
        code.put("GCG", "A");
        code.put("TAT", "Y");
        code.put("TAC", "Y");
        code.put("TAA", "*");
        code.put("TAG", "+");
        code.put("CAT", "H");
        code.put("CAC", "H");
        code.put("CAA", "Q");
        code.put("CAG", "Q");
        code.put("AAT", "N");
        code.put("AAC", "N");
        code.put("AAA", "K");
        code.put("AAG", "K");
        code.put("GAT", "D");
        code.put("GAC", "D");
        code.put("GAA", "E");
        code.put("GAG", "E");
        code.put("TGT", "C");
        code.put("TGC", "C");
        code.put("TGA", "#");
        code.put("TGG", "W");
        code.put("CGT", "R");
        code.put("CGC", "R");
        code.put("CGA", "R");
        code.put("CGG", "R");
        code.put("AGT", "S");
        code.put("AGC", "S");
        code.put("AGA", "R");
        code.put("AGG", "R");
        code.put("GGT", "G");
        code.put("GGC", "G");
        code.put("GGA", "G");
        code.put("GGG", "G");
        return code;
    }

    public static ArrayList<BitSet> FastaToBitSet(ArrayList<Fasta> seqs) {
        ArrayList<BitSet> newSeqs = new ArrayList<BitSet>();
        int i = 0;
        while (i < seqs.size()) {
            String sequence = seqs.get(i).getSequence().toUpperCase();
            if (sequence.contains("N")) {
                System.err.println("Left out a " + sequence.length() + "bp region since it contained Ns.");
            } else {
                newSeqs.add(DNAmanipulations.codeDNA(sequence));
            }
            ++i;
        }
        return newSeqs;
    }

    public static ArrayList<BitSet> toBitSet(ArrayList<String> seqs) {
        ArrayList<BitSet> newSeqs = new ArrayList<BitSet>();
        int i = 0;
        while (i < seqs.size()) {
            if (seqs.get(i).toUpperCase().contains("N")) {
                System.err.println("Left out a " + seqs.get(i).length() + "bp region since it contained Ns.");
            } else {
                newSeqs.add(DNAmanipulations.codeDNA(seqs.get(i).toUpperCase()));
            }
            ++i;
        }
        return newSeqs;
    }

    public static String decodeDNA(BitSet code) {
        StringBuilder DNA = new StringBuilder("");
        int i = 0;
        while (i < code.length() - 1) {
            if (!code.get(i) && !code.get(i + 1)) {
                DNA.append('A');
            } else if (!code.get(i) && code.get(i + 1)) {
                DNA.append('T');
            } else if (code.get(i) && !code.get(i + 1)) {
                DNA.append('C');
            } else if (code.get(i) && code.get(i + 1)) {
                DNA.append('G');
            }
            i += 2;
        }
        return DNA.toString();
    }

    public static String decodeDNA(long code, int length) {
        StringBuilder DNA = new StringBuilder("");
        int i = 0;
        while (i < length) {
            if (code % 4L == 0L) {
                DNA.append('A');
            } else if (code % 4L == 1L) {
                DNA.append('T');
            } else if (code % 4L == 2L) {
                DNA.append('C');
            } else if (code % 4L == 3L) {
                DNA.append('G');
            }
            code /= 4L;
            ++i;
        }
        return DNA.toString();
    }

    public static long codeDNALong(String dna) {
        long code = 0L;
        long A = 0L;
        long T = 1L;
        long C = 2L;
        long G = 3L;
        int i = 0;
        while (i < dna.length()) {
            long newLetter = 0L;
            if (dna.charAt(i) == 'A') {
                newLetter = A << (int)((long)i * 2L);
            } else if (dna.charAt(i) == 'T') {
                newLetter = T << (int)((long)i * 2L);
            } else if (dna.charAt(i) == 'C') {
                newLetter = C << (int)((long)i * 2L);
            } else if (dna.charAt(i) == 'G') {
                newLetter = G << (int)((long)i * 2L);
            } else {
                System.err.println("Wrong letter in DNA sequence: " + dna.charAt(i));
                return -1L;
            }
            code += newLetter;
            ++i;
        }
        return code;
    }

    public static BitSet codeDNA(String dna) {
        BitSet code = new BitSet(dna.length() * 2);
        dna = dna.toUpperCase();
        int i = 0;
        while (i < dna.length()) {
            if (dna.charAt(i) == 'A') {
                code.set(i * 2, false);
                code.set(i * 2 + 1, false);
            } else if (dna.charAt(i) == 'T') {
                code.set(i * 2, false);
                code.set(i * 2 + 1, true);
            } else if (dna.charAt(i) == 'C') {
                code.set(i * 2, true);
                code.set(i * 2 + 1, false);
            } else if (dna.charAt(i) == 'G') {
                code.set(i * 2, true);
                code.set(i * 2 + 1, true);
            } else {
                System.err.println("Wrong letter in DNA sequence: " + dna.charAt(i));
                return null;
            }
            ++i;
        }
        code.set(dna.length() * 2, true);
        return code;
    }
}

