/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class FileHandler {
    public static void merge(File file1, File file2, File out) {
        ArrayList<File> files = new ArrayList<File>();
        files.add(file1);
        files.add(file2);
        FileHandler.merge(files, out);
    }

    public static void merge(ArrayList<File> files, File out) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(out));
            int i = 0;
            while (i < files.size()) {
                BufferedReader br = new BufferedReader(new FileReader(files.get(i)));
                String line = "";
                while ((line = br.readLine()) != null) {
                    bw.write(String.valueOf(line) + "\n");
                }
                br.close();
                ++i;
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean deleteFolder(File folder) {
        if (folder.isDirectory()) {
            String[] children = folder.list();
            int i = 0;
            while (i < children.length) {
                boolean success = FileHandler.deleteFolder(new File(folder, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return folder.delete();
    }

    public static void copy(File source, File destination) {
        try {
            int len;
            FileInputStream in = new FileInputStream(source);
            FileOutputStream out = new FileOutputStream(destination);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (FileNotFoundException ex) {
            System.out.println(String.valueOf(ex.getMessage()) + " in the specified directory.");
            System.exit(0);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }
}

