/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import util.DNAmanipulations;
import util.ReadFasta;

public class Find {
    public static void main(String[] args) {
        String word = args[0];
        File genome = new File(args[1]);
        StringBuilder[] sb = ReadFasta.readFasta(genome).values().toArray(new StringBuilder[0]);
        int sum = 0;
        int i = 0;
        while (i < sb.length) {
            String sequence = sb[i].toString();
            sum += Find.getOccurrences(word, sequence.toUpperCase());
            ++i;
        }
        System.out.println(sum);
    }

    public static ArrayList<Integer> getPositions(ArrayList<String> words, ArrayList<String> sequence) {
        ArrayList<Integer> pos = new ArrayList<Integer>();
        System.out.println(String.valueOf(words.size()) + " words.");
        int i = 0;
        while (i < words.size()) {
            String word = words.get(i);
            int j = 0;
            while (j < sequence.size()) {
                pos.addAll(Find.getPositions(word, sequence.get(j)));
                pos.addAll(Find.getPositions(DNAmanipulations.reverse(word), sequence.get(j)));
                ++j;
            }
            ++i;
        }
        return pos;
    }

    public static ArrayList<Integer> getPositions(String word, String sequence) {
        ArrayList<Integer> pos = new ArrayList<Integer>();
        int i = 0;
        while ((i = sequence.indexOf(word, i)) != -1) {
            pos.add(i);
            ++i;
        }
        return pos;
    }

    public static int getOccurrences(ArrayList<BitSet> words, ArrayList<String> sequence) {
        int sum = 0;
        System.out.println(String.valueOf(words.size()) + " words.");
        int i = 0;
        while (i < words.size()) {
            String word = DNAmanipulations.decodeDNA(words.get(i));
            int j = 0;
            while (j < sequence.size()) {
                sum += Find.getOccurrences(word, sequence.get(j));
                ++j;
            }
            ++i;
        }
        return sum;
    }

    public static int getOccurrences(String word, String sequence) {
        int i = 0;
        int from = 0;
        sequence = sequence.toUpperCase();
        word = word.toUpperCase();
        while ((from = sequence.indexOf(word, from)) != -1) {
            ++i;
            ++from;
        }
        from = 0;
        String rev = DNAmanipulations.reverse(word);
        while ((from = sequence.indexOf(rev, from)) != -1) {
            ++i;
            ++from;
        }
        return i;
    }
}

