/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class Histogram<T> {
    TreeMap<T, Double> histogram = new TreeMap();
    ArrayList<TreeMap<T, Double>> elementHash = new ArrayList();
    TreeMap<T, Double> avg = new TreeMap();
    TreeMap<T, Double> stdv = new TreeMap();
    int numHist = 0;

    public Histogram(T[] elements) {
        this.makeHistogram(elements);
        this.numHist = 1;
    }

    public Histogram(TreeMap<T, Double> h) {
        this.histogram = h;
    }

    public void setAverage() {
        for (Map.Entry<T, Double> e : this.histogram.entrySet()) {
            this.avg.put(e.getKey(), e.getValue() / (double)this.numHist);
        }
    }

    public void setStandardDeviation() {
        HashMap<T, Double> help = new HashMap<T, Double>();
        int i = 0;
        while (i < this.elementHash.size()) {
            for (Map.Entry<T, Double> e : this.elementHash.get(i).entrySet()) {
                if (!help.containsKey(e.getKey())) {
                    help.put(e.getKey(), Math.pow(e.getValue() - this.avg.get(e.getKey()), 2.0) / (double)this.elementHash.size());
                    continue;
                }
                help.put(e.getKey(), (Double)help.get(e.getKey()) + Math.pow(e.getValue() - this.avg.get(e.getKey()), 2.0) / (double)this.elementHash.size());
            }
            ++i;
        }
        for (Map.Entry e : help.entrySet()) {
            this.stdv.put(e.getKey(), Math.sqrt((Double)e.getValue()));
        }
    }

    public void add(T[] elements) {
        this.elementHash.add(this.makeHistogram(elements));
        ++this.numHist;
    }

    public void max(T[] elements) {
        HashMap<T, Double> H2 = new HashMap<T, Double>();
        int i = 0;
        while (i < elements.length) {
            if (H2.containsKey(elements[i])) {
                H2.put(elements[i], (Double)H2.get(elements[i]) + 1.0);
            } else {
                H2.put(elements[i], 1.0);
            }
            ++i;
        }
        for (Map.Entry e : H2.entrySet()) {
            if (this.histogram.containsKey(e.getKey())) {
                if (!(this.histogram.get(e.getKey()) < (Double)e.getValue())) continue;
                this.histogram.put(e.getKey(), (Double)e.getValue());
                continue;
            }
            this.histogram.put(e.getKey(), (Double)e.getValue());
        }
    }

    private TreeMap<T, Double> makeHistogram(T[] elements) {
        TreeMap<T, Double> newHash = new TreeMap<T, Double>();
        int i = 0;
        while (i < elements.length) {
            if (this.histogram.containsKey(elements[i])) {
                this.histogram.put(elements[i], this.histogram.get(elements[i]) + 1.0);
            } else {
                this.histogram.put(elements[i], 1.0);
            }
            if (newHash.containsKey(elements[i])) {
                newHash.put(elements[i], (Double)newHash.get(elements[i]) + 1.0);
            } else {
                newHash.put(elements[i], 1.0);
            }
            ++i;
        }
        return newHash;
    }

    public TreeMap<T, Double> getHistogram() {
        return this.histogram;
    }

    public Double[] getValues() {
        return this.histogram.values().toArray(new Double[0]);
    }

    public TreeMap<Double, ArrayList<T>> sortByValues() {
        TreeMap<Double, ArrayList<T>> sorted = new TreeMap<Double, ArrayList<T>>();
        for (Map.Entry<T, Double> e : this.histogram.entrySet()) {
            if (sorted.containsKey(e.getValue())) {
                sorted.get(e.getValue()).add(e.getKey());
                continue;
            }
            ArrayList<T> a = new ArrayList<T>();
            a.add(e.getKey());
            sorted.put(e.getValue(), a);
        }
        return sorted;
    }

    public static TreeMap<Integer, Double> calculateProportionIntegral(TreeMap<Integer, Double> histogram) {
        Iterator<Map.Entry<Integer, Double>> it = histogram.entrySet().iterator();
        TreeMap<Integer, Double> tm = new TreeMap<Integer, Double>();
        double sum = 0.0;
        double prop = 0.0;
        while (it.hasNext()) {
            Map.Entry<Integer, Double> e = it.next();
            sum += (double)e.getKey().intValue() * e.getValue();
        }
        for (Map.Entry<Integer, Double> e : histogram.entrySet()) {
            tm.put(e.getKey(), (prop += (double)e.getKey().intValue() * e.getValue()) / sum);
        }
        return tm;
    }

    public void set(TreeMap<T, Double> h) {
        this.histogram = h;
    }

    public void writeSortedByValues(File out) {
        TreeMap<Double, ArrayList<T>> sorted = this.sortByValues();
        Iterator it = sorted.descendingMap().entrySet().iterator();
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(out));
            while (it.hasNext()) {
                Map.Entry e = it.next();
                int j = 0;
                while (j < ((ArrayList)e.getValue()).size()) {
                    bw.write(((ArrayList)e.getValue()).get(j) + "\t" + e.getKey() + "\n");
                    ++j;
                }
            }
            bw.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
        }
    }

    public TreeMap<T, Double> getStandardDeviation() {
        return this.stdv;
    }

    public TreeMap<T, Double> getAverage() {
        return this.avg;
    }

    public String write(String what) {
        StringBuffer out = new StringBuffer();
        Iterator<Map.Entry<T, Double>> it = what.equalsIgnoreCase("std") ? this.histogram.entrySet().iterator() : (what.equalsIgnoreCase("stdv") ? this.stdv.entrySet().iterator() : (what.equalsIgnoreCase("avg") ? this.avg.entrySet().iterator() : null));
        int old = 0;
        while (it.hasNext()) {
            Map.Entry<T, Double> e = it.next();
            if (e.getKey() instanceof Integer && (Integer)e.getKey() < 500) {
                int i = 1;
                while (i < (Integer)e.getKey() - old) {
                    out.append(String.valueOf(old + i) + "\t" + 0 + "\n");
                    ++i;
                }
                old = (Integer)e.getKey();
            }
            out.append(e.getKey() + "\t" + e.getValue() + "\n");
        }
        return out.toString();
    }

    public void write(File out, String what) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(out));
            bw.write(this.write(what));
            bw.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
        }
    }

    public static String write(HashMap<Integer, Integer> hist, int accuracy) {
        StringBuffer out = new StringBuffer();
        int i = 0;
        while (hist.size() > 0 && i < 5000000) {
            if (hist.containsKey(i)) {
                out.append(String.valueOf(i) + "\t" + hist.get(i) + "\n");
                hist.remove(i);
            }
            if ((i += accuracy) % 10000000 != 0) continue;
            System.out.println(i);
        }
        return out.toString();
    }

    public static String write(HashMap<String, Integer> hist) {
        StringBuffer out = new StringBuffer();
        for (Map.Entry<String, Integer> e : hist.entrySet()) {
            out.append(String.valueOf(e.getKey()) + "\t" + e.getValue() + "\n");
        }
        return out.toString();
    }

    public static void write(HashMap<String, Integer> hist, File f) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(f));
            bw.write(Histogram.write(hist));
            bw.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
        }
    }

    public static void write(HashMap<Integer, Integer> hist, int accuracy, File f) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(f));
            bw.write(Histogram.write(hist, accuracy));
            bw.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
        }
    }
}

