/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.ArrayList;
import java.util.HashMap;
import util.Info;
import util.IntervalTree;

public class InfoTree
extends IntervalTree<Info> {
    public void parseTree(IntervalTree.IntervalNode<Info> t, ArrayList<Info> intervals, HashMap<String, Boolean> feature) {
        if (t == nullNode) {
            return;
        }
        this.parseTree(t.left, intervals, feature);
        if (feature.containsKey(((Info)t.element).getFeature())) {
            intervals.add(new Info((Info)t.element));
        }
        this.parseTree(t.right, intervals, feature);
    }

    public void parseTree(IntervalTree.IntervalNode<Info> t, ArrayList<Info> intervals, HashMap<String, Boolean> feature, int minLength) {
        if (t == nullNode) {
            return;
        }
        this.parseTree(t.left, intervals, feature, minLength);
        if (feature.containsKey(((Info)t.element).getFeature()) && ((Info)t.element).end - ((Info)t.element).start >= minLength) {
            intervals.add(new Info((Info)t.element));
        }
        this.parseTree(t.right, intervals, feature, minLength);
    }

    public void parseTree(IntervalTree.IntervalNode<Info> t, ArrayList<Info> intervals, String feature) {
        if (t == nullNode) {
            return;
        }
        this.parseTree(t.left, intervals, feature);
        if (((Info)t.element).getFeature().equalsIgnoreCase(feature)) {
            intervals.add(new Info((Info)t.element));
        }
        this.parseTree(t.right, intervals, feature);
    }

    public void parseTree(IntervalTree.IntervalNode<Info> t, ArrayList<Info> intervals, String feature, int minLength) {
        if (t == nullNode) {
            return;
        }
        this.parseTree(t.left, intervals, feature, minLength);
        if (((Info)t.element).getFeature().equalsIgnoreCase(feature) && ((Info)t.element).end - ((Info)t.element).start >= minLength) {
            intervals.add(new Info((Info)t.element));
        }
        this.parseTree(t.right, intervals, feature, minLength);
    }

    public void parseTree(IntervalTree.IntervalNode<Info> t, ArrayList<Info> intervals) {
        if (t == nullNode) {
            return;
        }
        this.parseTree(t.left, intervals);
        intervals.add(new Info((Info)t.element));
        this.parseTree(t.right, intervals);
    }

    public boolean checkOverlap(Info inf) {
        ArrayList al = new ArrayList();
        this.search(inf, al);
        return al.size() > 0;
    }

    public ArrayList<Info> getOverlap(Info inf) {
        ArrayList<Info> al = new ArrayList<Info>();
        this.search(inf, al);
        return al;
    }

    public int getOverlapLength(Info inf) {
        ArrayList al = new ArrayList();
        this.search(inf, al);
        int[] array = new int[inf.size()];
        int infStart = inf.getStart();
        int infEnd = inf.getEnd();
        int i = 0;
        while (i < inf.size()) {
            array[i] = 0;
            ++i;
        }
        i = 0;
        while (i < al.size()) {
            Info temp = (Info)al.get(i);
            int j = temp.getStart();
            while (j < temp.getEnd()) {
                if (j >= infStart && j <= infEnd) {
                    array[j - infStart] = 1;
                }
                ++j;
            }
            ++i;
        }
        int sum = 0;
        int i2 = 0;
        while (i2 < array.length) {
            if (array[i2] == 1) {
                ++sum;
            }
            ++i2;
        }
        return sum;
    }

    public ArrayList<Info> parseTree() {
        ArrayList<Info> intervals = new ArrayList<Info>();
        this.parseTree(this.root, intervals);
        return intervals;
    }

    public ArrayList<Info> parseTree(String feature) {
        ArrayList<Info> intervals = new ArrayList<Info>();
        this.parseTree((IntervalTree.IntervalNode<Info>)this.root, intervals, feature);
        return intervals;
    }

    public ArrayList<Info> parseTree(HashMap<String, Boolean> feature) {
        ArrayList<Info> intervals = new ArrayList<Info>();
        this.parseTree((IntervalTree.IntervalNode<Info>)this.root, intervals, feature);
        return intervals;
    }

    public ArrayList<Info> parseTree(String feature, int minLength) {
        ArrayList<Info> intervals = new ArrayList<Info>();
        this.parseTree((IntervalTree.IntervalNode<Info>)this.root, intervals, feature, minLength);
        return intervals;
    }

    public ArrayList<Info> parseTree(HashMap<String, Boolean> feature, int minLength) {
        ArrayList<Info> intervals = new ArrayList<Info>();
        this.parseTree((IntervalTree.IntervalNode<Info>)this.root, intervals, feature, minLength);
        return intervals;
    }

    public ArrayList<Info> delete(ArrayList<Info> genesFlanked) {
        int i = 0;
        while (i < genesFlanked.size()) {
            this.remove(genesFlanked.get(i));
            ++i;
        }
        return this.parseTree();
    }

    public InfoTree() {
    }

    public InfoTree(ArrayList<Info> infos) {
        int i = 0;
        while (i < infos.size()) {
            this.insert(infos.get(i));
            ++i;
        }
    }
}

