/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.ArrayList;
import util.Info;
import util.Interval;
import util.ItemNotFoundException;

public class IntervalTree<T extends Interval<T>> {
    IntervalNode<T> root = nullNode;
    static IntervalNode nullNode = new IntervalNode<Object>(null, nullNode);
    private IntervalNode<T> deletedNode;
    private IntervalNode<T> lastNode;

    static {
        IntervalTree.nullNode.left = IntervalTree.nullNode.right = nullNode;
        IntervalTree.nullNode.level = 0;
        IntervalTree.nullNode.max = Integer.MIN_VALUE;
    }

    public void search(T inter, ArrayList<T> al) {
        this.search(this.root, inter, al);
    }

    public void insert(T x) {
        this.root = this.insert(x, this.root, null);
    }

    public void remove(T x) {
        this.deletedNode = nullNode;
        this.root = this.remove((Comparable<? super T>)x, this.root);
    }

    public T findMin() {
        if (this.isEmpty()) {
            return null;
        }
        IntervalNode<T> ptr = this.root;
        while (ptr.left != nullNode) {
            ptr = ptr.left;
        }
        return ptr.element;
    }

    public T findMax() {
        if (this.isEmpty()) {
            return null;
        }
        IntervalNode<T> ptr = this.root;
        while (ptr.right != nullNode) {
            ptr = ptr.right;
        }
        return ptr.element;
    }

    public void search(IntervalNode<T> n, T p, ArrayList<T> result) {
        if (n == nullNode) {
            return;
        }
        if (((Interval)p).start > n.max) {
            return;
        }
        if (n.left != nullNode) {
            this.search(n.left, p, result);
        }
        if (((Interval)n.element).overlapsWith(p)) {
            result.add(n.element);
        }
        if (((Interval)p).end < ((Interval)n.element).start) {
            return;
        }
        if (n.right != nullNode) {
            this.search(n.right, p, result);
        }
    }

    public Flank<T> findFlank(T x) {
        IntervalNode<T> current = this.root;
        Flank f = new Flank();
        while (true) {
            if (current.element != null && ((Interval)x).compareTo(current.element) < 0) {
                f.next = current.element;
                current = current.left;
                continue;
            }
            if (current.element == null || ((Interval)x).compareTo(current.element) <= 0) break;
            f.prev = current.element;
            current = current.right;
        }
        return f;
    }

    public T maxTree(IntervalNode<T> n) {
        while (n.right != nullNode) {
            n = n.right;
        }
        return n.element;
    }

    public T minTree(IntervalNode<T> n) {
        while (n.left != nullNode) {
            n = n.left;
        }
        return n.element;
    }

    public T predecessor(T x) {
        IntervalNode<T> current = this.root;
        while (true) {
            if (current.element == null) {
                return null;
            }
            if (((Interval)x).compareTo(current.element) < 0) {
                current = current.left;
                continue;
            }
            if (((Interval)x).compareTo(current.element) <= 0) break;
            current = current.right;
        }
        if (current != nullNode) {
            if (current.left != nullNode) {
                return this.maxTree(current.left);
            }
            IntervalNode p = current.dad;
            while (p != null && current == p.left) {
                current = p;
                p = p.dad;
            }
            if (p != null) {
                return p.element;
            }
            return null;
        }
        return null;
    }

    public T successor(T x) {
        IntervalNode<T> current = this.root;
        while (true) {
            if (current.element == null) {
                return null;
            }
            if (((Interval)x).compareTo(current.element) < 0) {
                current = current.left;
                continue;
            }
            if (((Interval)x).compareTo(current.element) <= 0) break;
            current = current.right;
        }
        if (current != nullNode) {
            if (current.right != nullNode) {
                return this.minTree(current.right);
            }
            IntervalNode p = current.dad;
            while (p != null && current == p.right) {
                current = p;
                p = p.dad;
            }
            if (p != null) {
                return p.element;
            }
            return null;
        }
        return null;
    }

    public T find(T x) {
        IntervalNode<T> current = this.root;
        while (true) {
            if (current.element == null) {
                return null;
            }
            if (((Interval)x).compareTo(current.element) < 0) {
                current = current.left;
                continue;
            }
            if (((Interval)x).compareTo(current.element) <= 0) break;
            current = current.right;
        }
        if (current != nullNode) {
            return current.element;
        }
        return null;
    }

    public void makeEmpty() {
        this.root = nullNode;
    }

    public boolean isEmpty() {
        return this.root == nullNode;
    }

    private void adjustMax(IntervalNode<T> t, int max) {
        if (t != null && t.max < max) {
            t.max = max;
            this.adjustMax(t.dad, max);
        }
    }

    private void adjustMaxDeletion(IntervalNode<T> t) {
        if (t != null) {
            t.max = this.max(((Interval)t.element).getEnd(), t.left.max, t.right.max);
        }
    }

    private IntervalNode<T> insert(T x, IntervalNode<T> t, IntervalNode<T> father) {
        if (t == nullNode) {
            t = new IntervalNode<T>(x, father);
            this.adjustMax(t.dad, ((Interval)x).end);
        } else if (((Interval)x).compareTo(t.element) < 0) {
            t.left = this.insert(x, t.left, t);
        } else if (((Interval)x).compareTo(t.element) > 0) {
            t.right = this.insert(x, t.right, t);
        } else {
            ((Interval)t.element).append(x);
        }
        t = this.skew(t);
        t = this.split(t);
        return t;
    }

    private IntervalNode<T> remove(Comparable<? super T> x, IntervalNode<T> t) {
        if (t != nullNode) {
            this.lastNode = t;
            if (x.compareTo(t.element) < 0) {
                t.left = this.remove(x, t.left);
                this.adjustMaxDeletion(t);
            } else {
                this.deletedNode = t;
                t.right = this.remove(x, t.right);
                this.adjustMaxDeletion(t);
            }
            if (t == this.lastNode) {
                if (this.deletedNode == nullNode || x.compareTo(this.deletedNode.element) != 0) {
                    throw new ItemNotFoundException(x.toString());
                }
                this.deletedNode.element = t.element;
                t = t.right;
            } else if (t.left.level < t.level - 1 || t.right.level < t.level - 1) {
                if (t.right.level > --t.level) {
                    t.right.level = t.level;
                }
                t = this.skew(t);
                t.right = this.skew(t.right);
                t.right.right = this.skew(t.right.right);
                t = this.split(t);
                t.right = this.split(t.right);
            }
        }
        return t;
    }

    private IntervalNode<T> skew(IntervalNode<T> t) {
        if (t.left.level == t.level) {
            t = this.rotateWithLeftChild(t);
        }
        return t;
    }

    private IntervalNode<T> split(IntervalNode<T> t) {
        if (t.right.right.level == t.level) {
            t = this.rotateWithRightChild(t);
            ++t.level;
        }
        return t;
    }

    private IntervalNode<T> rotateWithLeftChild(IntervalNode<T> k2) {
        IntervalNode k1 = k2.left;
        k1.dad = k2.dad;
        k2.left = k1.right;
        k1.right = k2;
        k1.max = k2.max;
        int rightleft = k1.right.left == null ? Integer.MIN_VALUE : k1.right.left.max;
        int rightright = k1.right.right == null ? Integer.MIN_VALUE : k1.right.right.max;
        int rightelement = k1.right == nullNode ? Integer.MIN_VALUE : ((Interval)k1.right.element).getEnd();
        k1.right.max = this.max(rightelement, rightleft, rightright);
        k1.right.dad = k1;
        k1.right.left.dad = k1.right;
        return k1;
    }

    private IntervalNode<T> rotateWithRightChild(IntervalNode<T> k1) {
        IntervalNode k2 = k1.right;
        k2.dad = k1.dad;
        k1.right = k2.left;
        k2.left = k1;
        k2.max = k1.max;
        k2.left.max = this.max(k2.left.left.max, k2.left.right.max, ((Interval)k2.left.element).end);
        k2.left.dad = k2;
        k2.left.right.dad = k2.left;
        return k2;
    }

    private int max(int m1, int m2, int m3) {
        return m1 >= m2 && m1 >= m3 ? m1 : (m2 >= m3 && m2 >= m1 ? m2 : m3);
    }

    public void parseTree(IntervalNode<T> t) {
        if (t == nullNode) {
            return;
        }
        System.out.println(((Interval)t.element).start + " " + ((Interval)t.element).end + " " + t.max);
        this.parseTree(t.left);
        this.parseTree(t.right);
    }

    public static void main(String[] args) {
        IntervalTree<Info> t = new IntervalTree<Info>();
        t.insert(new Info(100, 200, "1", 43));
        t.insert(new Info(200, 250, "2", 43));
        t.insert(new Info(300, 350, "3", 43));
        Flank<Info> f = t.findFlank(new Info(200, 250, "1", 43));
        System.out.println(f.prev + "\n" + f.next);
        t.insert(new Info(1, 2, "bla", 43));
        t.insert(new Info(2, 3, "bla", 43));
        t.insert(new Info(3, 4, "bla", 43));
        t.insert(new Info(4, 5, "bla", 43));
        t.insert(new Info(5, 10, "bla", 43));
        System.out.println("_____________");
        t.insert(new Info(2, 7, "bla", 43));
        System.out.println("_____________");
        t.insert(new Info(6, 8, "bla", 43));
        System.out.println("_____________");
        t.insert(new Info(7, 11, "bla", 43));
        System.out.println("_____________");
        t.insert(new Info(2, 4, "bla", 43));
        System.out.println("_____________");
        t.insert(new Info(15, 12, "bla", 43));
        System.out.println("_____________");
        t.insert(new Info(1, 9, "bla", 43));
        System.out.println("_____________");
        t.insert(new Info(-3, 8, "bla", 43));
        t.remove(new Info(1, 9, "bla", 43));
        t.remove(new Info(-3, 8, "bla", 43));
        t.remove(new Info(15, 12, "bla", 43));
        System.out.println(t.successor(new Info(7, 11, "bla", 43)));
    }

    public static class Flank<T> {
        public T prev = null;
        public T next = null;

        public Flank() {
        }

        public Flank(T Prev, T Next) {
            this.prev = Prev;
            this.next = Next;
        }
    }

    static class IntervalNode<T extends Interval<?>> {
        int max;
        T element;
        IntervalNode<T> left;
        IntervalNode<T> right;
        int level;
        IntervalNode<T> dad;

        IntervalNode(T theElement, IntervalNode<T> father) {
            this.dad = father;
            this.element = theElement;
            this.right = this.left = nullNode;
            this.level = 1;
            this.max = theElement != null ? ((Interval)theElement).end : Integer.MIN_VALUE;
        }
    }
}

