/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import util.Feature;
import util.Property;

public class ReadArtemis {
    ArrayList<ArrayList<Feature>> artemisMap = new ArrayList();

    public ReadArtemis(File artemis) {
        this.read(artemis);
    }

    public ArrayList<Feature> getFeatures(int pos1, int pos2) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        HashMap<Feature, Integer> check = new HashMap<Feature, Integer>();
        int i = pos1;
        while (i <= pos2) {
            int j = 0;
            while (j < this.artemisMap.get(i).size()) {
                if (!check.containsKey(this.artemisMap.get(i).get(j))) {
                    features.add(this.artemisMap.get(i).get(j));
                    check.put(this.artemisMap.get(i).get(j), 1);
                }
                ++j;
            }
            ++i;
        }
        return features;
    }

    public ArrayList<Feature> getFeatures(int pos1, int pos2, String featureName) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        HashMap<Feature, Integer> check = new HashMap<Feature, Integer>();
        int i = pos1;
        while (i <= pos2) {
            int j = 0;
            while (j < this.artemisMap.get(i).size()) {
                if (!check.containsKey(this.artemisMap.get(i).get(j)) && featureName.equals(this.artemisMap.get((int)i).get((int)j).name)) {
                    features.add(this.artemisMap.get(i).get(j));
                    check.put(this.artemisMap.get(i).get(j), 1);
                }
                ++j;
            }
            ++i;
        }
        return features;
    }

    public ArrayList<Feature> getFeatures(ArrayList<Integer> posList) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        HashMap<Feature, Integer> check = new HashMap<Feature, Integer>();
        int k = 0;
        while (k < posList.size() - 1) {
            int pos1 = posList.get(k);
            int pos2 = posList.get(k + 1);
            int i = pos1;
            while (i <= pos2) {
                int j = 0;
                while (j < this.artemisMap.get(i).size()) {
                    if (!check.containsKey(this.artemisMap.get(i).get(j))) {
                        features.add(this.artemisMap.get(i).get(j));
                        check.put(this.artemisMap.get(i).get(j), 1);
                    }
                    ++j;
                }
                ++i;
            }
            k += 2;
        }
        return features;
    }

    public BitSet getBoolArray(String featureName) {
        BitSet ba = new BitSet(this.artemisMap.size());
        ArrayList<Integer> posList = this.getPos(featureName);
        int j = 0;
        while (j < posList.size() - 1) {
            int k = posList.get(j);
            while (k < posList.get(j + 1)) {
                ba.set(k, true);
                ++k;
            }
            j += 2;
        }
        ba.set(this.artemisMap.size() + 1);
        return ba;
    }

    public ArrayList<Integer> getPos(String featureName) {
        ArrayList<Integer> posList = new ArrayList<Integer>();
        ArrayList<Feature> features = this.getFeatures(0, this.artemisMap.size() - 1, featureName);
        int i = 0;
        while (i < features.size()) {
            ArrayList<Integer> start = features.get((int)i).start;
            ArrayList<Integer> end = features.get((int)i).end;
            int j = 0;
            while (j < start.size()) {
                posList.add(start.get(j));
                posList.add(end.get(j));
                ++j;
            }
            ++i;
        }
        return posList;
    }

    public static String featuresToString(ArrayList<Feature> features) {
        StringBuilder feature = new StringBuilder("");
        int i = 0;
        while (i < features.size()) {
            Feature f = features.get(i);
            feature.append("FT   " + f.name + "            ");
            if (f.start.size() > 1) {
                feature.append("join(");
            }
            if (f.complement) {
                feature.append("complement(");
            }
            int j = 0;
            while (j < f.start.size() - 1) {
                feature.append(f.start.get(j) + ".." + f.end.get(j) + ",");
                ++j;
            }
            feature.append(f.start.get(f.start.size() - 1) + ".." + f.end.get(f.end.size() - 1));
            if (f.start.size() > 1) {
                feature.append(")");
            }
            if (f.complement) {
                feature.append(")");
            }
            feature.append("\n");
            j = 0;
            while (j < f.properties.size()) {
                feature.append("FT                   /" + f.properties.get((int)j).Name + "=" + f.properties.get((int)j).Value + "\n");
                ++j;
            }
            ++i;
        }
        return feature.toString();
    }

    public void read(File artemis) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(artemis));
            String line = "";
            ArrayList<Property> properties = new ArrayList<Property>();
            int lineNumber = 0;
            Feature f = new Feature();
            while ((line = br.readLine()) != null) {
                int i;
                if (++lineNumber == 1000) {
                    System.out.println("tst");
                }
                if (line.matches("FT   \\S+\\s+.+")) {
                    properties = new ArrayList(1);
                    if (line.contains("complement(")) {
                        line = line.replace("complement(", "");
                        line = line.replace(")", "");
                        f.complement = true;
                    } else {
                        f.complement = false;
                    }
                    if (line.contains("join(")) {
                        line = line.replace("join(", "");
                        line = line.replace(")", "");
                    }
                    if (line.contains("order(")) {
                        line = line.replace("order(", "");
                        line = line.replace(")", "");
                    }
                    String[] features = line.split("\\.\\.>|\\s+<|\\s+|\\.\\.|,");
                    f = new Feature();
                    f.name = features[1];
                    f.start = new ArrayList(1);
                    f.end = new ArrayList(1);
                    int i2 = 2;
                    while (i2 < features.length) {
                        int j;
                        int pos1 = Integer.parseInt(features[i2]);
                        int pos2 = Integer.parseInt(features[i2 + 1]);
                        int t = pos1;
                        pos1 = pos1 > pos2 ? pos2 : pos1;
                        int n = pos2 = pos1 > pos2 ? t : pos2;
                        if (pos2 >= this.artemisMap.size()) {
                            j = this.artemisMap.size();
                            while (j <= pos2 + 1) {
                                this.artemisMap.add(new ArrayList(1));
                                ++j;
                            }
                        }
                        f.start.add(pos1);
                        f.end.add(pos2);
                        f.properties = properties;
                        j = pos1;
                        while (j <= pos2) {
                            this.artemisMap.get(j).add(f);
                            ++j;
                        }
                        i2 += 2;
                    }
                    continue;
                }
                if (line.matches("FT   \\s+/.+")) {
                    String[] prop = line.split("\\s+|/|=");
                    Property p = new Property();
                    p.Name = prop[2];
                    p.Value = "";
                    i = 3;
                    while (i < prop.length - 1) {
                        p.Value = String.valueOf(p.Value) + prop[i] + " ";
                        ++i;
                    }
                    p.Value = String.valueOf(p.Value) + prop[prop.length - 1];
                    properties.add(p);
                    continue;
                }
                if (!line.matches("FT   \\s+.+")) continue;
                Property p = (Property)properties.get(properties.size() - 1);
                String[] prop = line.split("\\s+");
                i = 3;
                while (i < prop.length - 1) {
                    p.Value = String.valueOf(p.Value) + prop[i] + " ";
                    ++i;
                }
            }
        }
        catch (IOException e) {
            System.err.println(e.toString());
        }
    }
}

