/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import util.DNAmanipulations;
import util.Fasta;
import util.Info;
import util.InfoTree;

public class ReadGenbank {
    ArrayList<Fasta> sequence = new ArrayList();
    HashMap<String, InfoTree> infoHash = new HashMap();
    ArrayList<String> ids = new ArrayList();

    public ArrayList<Info> getFeatures(Info pos, String id) {
        ArrayList<Info> al = new ArrayList<Info>();
        this.infoHash.get(id).search(pos, al);
        return al;
    }

    public ArrayList<Info> getFeatures(Info pos) {
        ArrayList<Info> al = new ArrayList<Info>();
        this.infoHash.get(this.ids.get(0)).search(pos, al);
        return al;
    }

    public ArrayList<String> getIds() {
        return this.ids;
    }

    public static void main(String[] args) {
        ReadGenbank rgb = new ReadGenbank(new File(args[0]), new String[0]);
        System.out.println(rgb.getSequence());
    }

    public ReadGenbank(File GBK, String ... features) {
        this.parseGBK(GBK, features);
    }

    public InfoTree getInfoTree(String feature, String id) {
        ArrayList<Info> features = this.getIntervals(feature, id);
        InfoTree itree = new InfoTree();
        int i = 0;
        while (i < features.size()) {
            itree.insert(features.get(i));
            ++i;
        }
        return itree;
    }

    public InfoTree getInfoTree(String feature) {
        ArrayList<Info> features = this.getIntervals(feature, this.ids.get(0));
        InfoTree itree = new InfoTree();
        int i = 0;
        while (i < features.size()) {
            itree.insert(features.get(i));
            ++i;
        }
        return itree;
    }

    public InfoTree getWholeInfoTree() {
        return this.infoHash.get(this.ids.get(0));
    }

    public InfoTree getWholeInfoTree(String id) {
        return this.infoHash.get(id);
    }

    public ArrayList<Info> getIntervals(String feature, String id) {
        ArrayList<Info> al = new ArrayList();
        al = this.infoHash.get(id).parseTree(feature);
        return al;
    }

    public ArrayList<Info> getIntervals(HashMap<String, Boolean> feature) {
        ArrayList<Info> al = new ArrayList();
        al = this.infoHash.get(this.ids.get(0)).parseTree(feature);
        return al;
    }

    public ArrayList<Info> getIntervals(String feature) {
        ArrayList<Info> al = new ArrayList();
        al = this.infoHash.get(this.ids.get(0)).parseTree(feature);
        return al;
    }

    public ArrayList<Info> getIntervals(String feature, int minLength, String id) {
        ArrayList<Info> al = new ArrayList();
        al = this.infoHash.get(id).parseTree(feature, minLength);
        return al;
    }

    public ArrayList<Info> getIntervals(String feature, int minLength) {
        ArrayList<Info> al = new ArrayList();
        al = this.infoHash.get(this.ids.get(0)).parseTree(feature, minLength);
        return al;
    }

    public ArrayList<Info> getFeatures(String id) {
        return this.infoHash.get(id).parseTree();
    }

    public ArrayList<Fasta> getFeaturesSequences() {
        ArrayList<Fasta> features = new ArrayList<Fasta>();
        int count = 0;
        int i = 0;
        while (i < this.sequence.size()) {
            ArrayList<Info> infList = this.infoHash.get(this.sequence.get(i).getIdent()).parseTree();
            String wholeSeq = this.sequence.get(i).getSequence();
            int j = 0;
            while (j < infList.size()) {
                Info inf = infList.get(j);
                String ident = String.valueOf(count) + " " + inf.info;
                String sequence = inf.orient == '+' ? wholeSeq.substring(inf.start, inf.end) : DNAmanipulations.reverse(wholeSeq.substring(inf.start, inf.end));
                features.add(new Fasta(ident, sequence));
                ++count;
                ++j;
            }
            ++i;
        }
        return features;
    }

    public ArrayList<Info> getFirstSequenceFeatures() {
        return this.infoHash.get(this.ids.get(0)).parseTree();
    }

    public HashMap<String, ArrayList<Info>> getFeatures() {
        HashMap<String, ArrayList<Info>> hm = new HashMap<String, ArrayList<Info>>();
        int i = 0;
        while (i < this.ids.size()) {
            hm.put(this.ids.get(i), this.infoHash.get(this.ids.get(i)).parseTree());
            ++i;
        }
        return hm;
    }

    public ArrayList<Fasta> getSequence() {
        return this.sequence;
    }

    private static HashMap<String, Boolean> makeHash(String ... args) {
        HashMap<String, Boolean> hm = new HashMap<String, Boolean>();
        int i = 0;
        while (i < args.length) {
            hm.put(args[i], true);
            ++i;
        }
        return hm;
    }

    private void parseGBK(File GBK, String ... onlyFeature) {
        try {
            HashMap<String, Boolean> oFeature = onlyFeature.length > 0 ? ReadGenbank.makeHash(onlyFeature) : null;
            BufferedReader br = new BufferedReader(new FileReader(GBK));
            String line = "";
            int start = -1;
            int end = -1;
            String info = "";
            boolean found = false;
            boolean complement = false;
            String locus = "";
            InfoTree infoTree = new InfoTree();
            boolean origin = false;
            StringBuffer tempSeq = new StringBuffer();
            int codon_start = -1;
            boolean pseudo = false;
            String feature = "";
            while ((line = br.readLine()) != null) {
                if (line.matches("^\\s+\\S+\\s+complement\\(join.+") || line.matches("^\\s+\\S+\\s+join\\(.+")) {
                    char orient;
                    found = false;
                    if (info.length() <= 0 || start <= -1) continue;
                    info = complement ? String.valueOf(info) + " complement" : info;
                    char c = orient = complement ? (char)'-' : '+';
                    if (oFeature == null || oFeature.containsKey(feature)) {
                        infoTree.insert(new Info(start, end, info).setOrient(orient).setPseudo(pseudo).setFeature(feature));
                    }
                    info = new String("");
                    pseudo = false;
                    continue;
                }
                if (line.startsWith("LOCUS")) {
                    if (start > -1 && info.length() > 0) {
                        char orient;
                        info = complement ? String.valueOf(info) + " complement" : info;
                        char c = orient = complement ? (char)'-' : '+';
                        if (oFeature == null || oFeature.containsKey(feature)) {
                            infoTree.insert(new Info(start, end, info).setOrient(orient).setPseudo(pseudo).setFeature(feature));
                        }
                        this.infoHash.put(locus, infoTree);
                        this.ids.add(locus);
                        pseudo = false;
                    }
                    origin = false;
                    locus = line.split("\\s+")[1];
                    infoTree = new InfoTree();
                    start = -1;
                    continue;
                }
                if (line.matches("^\\s+\\S+\\s+complement\\(\\d+.*") || line.matches("^\\s+\\S+\\s+<*\\d+\\.\\.>*\\d+\\s*")) {
                    Matcher m = Pattern.compile("^\\s+(\\S+)\\s+complement\\(<*(\\d+)\\.\\.>*(\\d+)\\)").matcher(line);
                    if (info.length() > 0 && start > -1) {
                        char orient;
                        info = complement ? String.valueOf(info) + " complement" : info;
                        char c = orient = complement ? (char)'-' : '+';
                        if (oFeature == null || oFeature.containsKey(feature)) {
                            if (codon_start > -1) {
                                Info inf = new Info(start, end, info).setOrient(orient).setCodonStart(codon_start).setPseudo(pseudo).setFeature(feature);
                                infoTree.insert(inf);
                                System.out.println(String.valueOf(feature) + " sss " + inf.getFeature());
                            } else {
                                infoTree.insert(new Info(start, end, info).setOrient(orient).setPseudo(pseudo).setFeature(feature));
                            }
                        }
                        pseudo = false;
                    }
                    complement = true;
                    if (!m.find()) {
                        m = Pattern.compile("^\\s+(\\S+)\\s+<*(\\d+)\\.\\.>*(\\d+)\\s*").matcher(line);
                        complement = false;
                        if (!m.find()) {
                            m = Pattern.compile("^\\s+(\\S+)\\s+<*>*(\\d+)").matcher(line);
                            complement = false;
                            if (!m.find()) {
                                m = Pattern.compile("^\\s+(\\S+)\\s+complement\\(<*>*(\\d+)\\)").matcher(line);
                                complement = true;
                            }
                        }
                    }
                    m.reset();
                    m.find();
                    start = Integer.parseInt(m.group(2));
                    end = m.groupCount() == 3 ? Integer.parseInt(m.group(3)) : start;
                    info = " ";
                    feature = m.group(1);
                    found = true;
                    continue;
                }
                if (found && line.matches("\\s+/note=\".+")) {
                    Matcher m = Pattern.compile("\\s+/(note=\".+)").matcher(line);
                    m.find();
                    info = String.valueOf(info) + m.group(1) + " ";
                    info = info.replace('\"', ' ');
                    continue;
                }
                if (found && line.matches("\\s+/product=\".+")) {
                    Matcher m = Pattern.compile("\\s+/(product=\".+)").matcher(line);
                    m.find();
                    info = String.valueOf(info) + m.group(1).replace(' ', '_') + " ";
                    info = info.replace('\"', ' ');
                    continue;
                }
                if (found && line.matches("\\s+/colour=.+")) {
                    Matcher m = Pattern.compile("\\s+/colour=(.+)").matcher(line);
                    m.find();
                    info = String.valueOf(info) + "colour= " + m.group(1) + " ";
                    info = info.replace('\"', ' ');
                    continue;
                }
                if (found && line.matches("\\s+/EC_number=\".+")) {
                    Matcher m = Pattern.compile("\\s+/(EC_number=\".+)").matcher(line);
                    m.find();
                    info = String.valueOf(info) + m.group(1) + " ";
                    info = info.replace('\"', ' ');
                    continue;
                }
                if (found && line.matches("\\s+/codon_start=\".+")) {
                    Matcher m = Pattern.compile("\\s+/codon_start=\"(.+)").matcher(line);
                    m.find();
                    codon_start = Integer.parseInt(m.group(1));
                    continue;
                }
                if (found && line.matches("\\s+/locus_tag=\".+")) {
                    Matcher m = Pattern.compile("\\s+/(locus_tag=\".+)").matcher(line);
                    m.find();
                    info = String.valueOf(info) + m.group(1) + " ";
                    info = info.replace('\"', ' ');
                    continue;
                }
                if (found && line.matches("\\s+/gene=\".+")) {
                    Matcher m = Pattern.compile("\\s+/(gene=\".+)").matcher(line);
                    m.find();
                    info = String.valueOf(info) + m.group(1) + " ";
                    info = info.replace('\"', ' ');
                    continue;
                }
                if (found && line.matches("\\s+/mobile_element=\".+")) {
                    Matcher m = Pattern.compile("\\s+/(mobile_element=\".+)").matcher(line);
                    m.find();
                    info = String.valueOf(info) + m.group(1) + " ";
                    info = info.replace('\"', ' ');
                    continue;
                }
                if (found && line.matches("\\s+/pseudo\\s+")) {
                    pseudo = true;
                    continue;
                }
                if (line.startsWith("//")) {
                    origin = false;
                    this.sequence.add(new Fasta(locus, tempSeq.toString()));
                    tempSeq = new StringBuffer();
                    continue;
                }
                if (line.startsWith("ORIGIN")) {
                    origin = true;
                    continue;
                }
                if (!origin) continue;
                String[] split = line.split("\\s+");
                int i = 2;
                while (i < split.length) {
                    tempSeq.append(split[i]);
                    ++i;
                }
            }
            if (found) {
                char orient;
                info = complement ? String.valueOf(info) + " complement" : info;
                char c = orient = complement ? (char)'-' : '+';
                if (oFeature == null || oFeature.containsKey(feature)) {
                    if (codon_start > -1) {
                        infoTree.insert(new Info(start, end, info).setOrient(orient).setCodonStart(codon_start).setPseudo(pseudo).setFeature(feature));
                    } else {
                        infoTree.insert(new Info(start, end, info).setOrient(orient).setPseudo(pseudo).setFeature(feature));
                    }
                }
                this.infoHash.put(locus, infoTree);
                this.ids.add(locus);
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

