/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.util.ArrayList;
import util.Fasta;

public class TranslateAmbiguousToFasta {
    public static void main(String[] args) {
        File in = new File(args[0]);
        File out = new File(args[1]);
        ArrayList<Fasta> fasta = Fasta.readFasta(in);
        Fasta.write(TranslateAmbiguousToFasta.translate(fasta), out);
    }

    public static ArrayList<Fasta> translate(ArrayList<Fasta> in) {
        ArrayList<Fasta> translated = new ArrayList<Fasta>();
        int i = 0;
        while (i < in.size()) {
            ArrayList<StringBuilder> seqs = TranslateAmbiguousToFasta.translateSeq(in.get(i).getSequence());
            int j = 0;
            while (j < seqs.size()) {
                translated.add(new Fasta(String.valueOf(in.get((int)i).ident) + "_" + j, seqs.get(j).toString()));
                ++j;
            }
            ++i;
        }
        return translated;
    }

    public static ArrayList<StringBuilder> translateSeq(String seq) {
        ArrayList<StringBuilder> results = new ArrayList<StringBuilder>();
        results.add(new StringBuilder());
        int i = 0;
        while (i < seq.length()) {
            if (seq.charAt(i) == '[') {
                ArrayList<Character> list = new ArrayList<Character>();
                ++i;
                while (seq.charAt(i) != ']') {
                    list.add(Character.valueOf(seq.charAt(i)));
                    ++i;
                }
                results = TranslateAmbiguousToFasta.appendChars(results, list);
            } else {
                int j = 0;
                while (j < results.size()) {
                    results.get(j).append(seq.charAt(i));
                    ++j;
                }
            }
            ++i;
        }
        return results;
    }

    public static ArrayList<StringBuilder> appendChars(ArrayList<StringBuilder> old, ArrayList<Character> list) {
        ArrayList<StringBuilder> newList = new ArrayList<StringBuilder>();
        int i = 0;
        while (i < list.size()) {
            int j = 0;
            while (j < old.size()) {
                StringBuilder temp = new StringBuilder(old.get(j));
                newList.add(temp.append(list.get(i)));
                ++j;
            }
            ++i;
        }
        return newList;
    }
}

