/*
 * Decompiled with CFR 0.152.
 */
package util.phylogenetics;

import java.util.ArrayList;
import util.Fasta;

public class Alignment {
    int length;
    int numSeqs;
    ArrayList<StringBuffer> seqs = new ArrayList();
    ArrayList<String> idents = new ArrayList();

    public ArrayList<String> getIdents() {
        return this.idents;
    }

    public Alignment(ArrayList<Fasta> fas) throws RuntimeException {
        this.numSeqs = fas.size();
        this.idents = new ArrayList();
        this.seqs = new ArrayList();
        if (this.numSeqs <= 1) {
            throw new RuntimeException("The alignment needs to contain at least two sequences.\n");
        }
        this.checkLengthAndBases(fas);
    }

    public Alignment(Alignment al) {
        this.numSeqs = al.numSeqs;
        this.length = al.length;
        int i = 0;
        while (i < al.numSeqs) {
            this.seqs.add(new StringBuffer(al.seqs.get(i)));
            ++i;
        }
        i = 0;
        while (i < al.numSeqs) {
            this.idents.add(new String(al.idents.get(i)));
            ++i;
        }
    }

    public Alignment(Alignment al, int start, int end) {
        this.numSeqs = al.numSeqs;
        this.length = al.length;
        int i = 0;
        while (i < al.numSeqs) {
            this.seqs.add(new StringBuffer(al.seqs.get(i).substring(start, end)));
            ++i;
        }
        i = 0;
        while (i < al.numSeqs) {
            this.idents.add(new String(al.idents.get(i)));
            ++i;
        }
    }

    public Alignment() {
        this.numSeqs = 0;
        this.length = 0;
        this.seqs = new ArrayList();
        this.idents = new ArrayList();
    }

    public ArrayList<Fasta> toFasta() {
        ArrayList<Fasta> fas = new ArrayList<Fasta>();
        int i = 0;
        while (i < this.numSeqs) {
            fas.add(new Fasta(this.idents.get(i), this.seqs.get(i).toString()));
            ++i;
        }
        return fas;
    }

    public void addColumn(String col) {
        int i;
        if (this.numSeqs == 0) {
            this.numSeqs = col.length();
            this.length = 0;
            i = 0;
            while (i < this.numSeqs) {
                this.idents.add(String.valueOf(i));
                this.seqs.add(new StringBuffer());
                ++i;
            }
        } else if (col.length() != this.numSeqs) {
            throw new RuntimeException("Column length (" + col.length() + ") has to be identical to the existing sequence number (" + this.numSeqs + ") in order to be added.");
        }
        col = col.toUpperCase();
        i = 0;
        while (i < this.numSeqs) {
            this.seqs.get(i).append(this.checkBase(col.charAt(i), this.length, i));
            ++i;
        }
        ++this.length;
    }

    public void changeIdents(ArrayList<String> Idents) {
        this.idents = Idents;
    }

    public char getBase(int seq, int pos) {
        return this.seqs.get(seq).charAt(pos);
    }

    public String getSequence(int num) {
        return this.seqs.get(num).toString();
    }

    public String getIdent(int num) {
        return this.idents.get(num);
    }

    public int getLength() {
        return this.length;
    }

    public int getNumSeqs() {
        return this.numSeqs;
    }

    public String getColumn(int pos) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.numSeqs) {
            sb.append(this.seqs.get(i).charAt(pos));
            ++i;
        }
        return sb.toString();
    }

    public Alignment getRegion(int start, int end) {
        Alignment al = new Alignment(this, start, end);
        return al;
    }

    private void checkLengthAndBases(ArrayList<Fasta> fas) throws RuntimeException {
        this.length = fas.get(0).getSequence().length();
        int i = 0;
        while (i < this.numSeqs) {
            if (fas.get(i).getSequence().length() != this.length) {
                throw new RuntimeException("All sequences have to be of the same length.\n" + fas.get(0).getIdent() + " length: " + this.length + "\n" + fas.get(i).getIdent() + " length: " + fas.get(i).getSequence().length() + "\n");
            }
            StringBuffer seq = new StringBuffer(fas.get(i).getSequence().toUpperCase());
            this.idents.add(fas.get(i).getIdent());
            int j = 0;
            while (j < this.length) {
                char c = seq.charAt(j);
                seq.setCharAt(j, this.checkBase(c, j, i));
                ++j;
            }
            this.seqs.add(seq);
            ++i;
        }
    }

    private char checkBase(char c, int pos, int seqNumber) {
        if (c != 'A' && c != 'T' && c != 'C' && c != 'G' && c != '-') {
            System.err.println("Changed character " + c + " in sequence " + this.idents.get(seqNumber) + " at position " + pos + " to " + "-.");
            return '-';
        }
        return c;
    }
}

